/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class WildcardGristCost
implements GristCostRecipe {
    private final Ingredient ingredient;
    private final Integer priority;
    private final long wildcardCost;

    public WildcardGristCost(Ingredient ingredient, long wildcardCost, Optional<Integer> priority) {
        this.ingredient = ingredient;
        this.priority = priority.orElse(null);
        this.wildcardCost = wildcardCost;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    @Override
    public int getPriority() {
        return Objects.requireNonNullElseGet(this.priority, () -> GristCostRecipe.defaultPriority(this.ingredient));
    }

    @Override
    @Nullable
    public GristSet getGristCost(ItemStack input, @Nullable GristType wildcardType, boolean shouldRoundDown) {
        return wildcardType != null ? GristCostRecipe.scaleToCountAndDurability(wildcardType.amount(this.wildcardCost), input, shouldRoundDown) : null;
    }

    @Override
    public boolean canPickWildcard() {
        return true;
    }

    @Override
    public void addCostProvider(BiConsumer<Item, GeneratedCostProvider> consumer, ResourceLocation recipeId) {
        GristCostRecipe.addSimpleCostProvider(consumer, this, this.ingredient);
    }

    @Override
    public List<JeiGristCost> getJeiCosts(Level level) {
        return Collections.singletonList(new JeiGristCost.Wildcard(this.ingredient, this.wildcardCost));
    }

    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.WILDCARD_GRIST_COST.get();
    }

    public static class Serializer
    implements RecipeSerializer<WildcardGristCost> {
        private static final MapCodec<WildcardGristCost> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.LONG.fieldOf("grist_cost").forGetter(recipe -> recipe.wildcardCost), (App)Codec.INT.optionalFieldOf("priority").forGetter(recipe -> Optional.ofNullable(recipe.priority))).apply((Applicative)instance, WildcardGristCost::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, WildcardGristCost> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<WildcardGristCost> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WildcardGristCost> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, WildcardGristCost recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeInt(recipe.getPriority());
            buffer.writeLong(recipe.wildcardCost);
        }

        private static WildcardGristCost fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int priority = buffer.readInt();
            long wildcardCost = buffer.readLong();
            return new WildcardGristCost(ingredient, wildcardCost, Optional.of(priority));
        }
    }
}

