/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.Item;

public final class GeneratedGristCostCache {
    @Nullable
    private GristSet.Immutable cachedCost = null;
    private boolean hasGeneratedCost = false;

    public void fromNetwork(RegistryFriendlyByteBuf buffer) {
        this.hasGeneratedCost = true;
        this.cachedCost = buffer.readBoolean() ? (GristSet.Immutable)GristSet.Codecs.STREAM_CODEC.decode((Object)buffer) : null;
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        if (this.cachedCost != null) {
            buffer.writeBoolean(true);
            GristSet.Codecs.STREAM_CODEC.encode((Object)buffer, (Object)this.cachedCost);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Nullable
    public GristSet.Immutable getCachedCost() {
        return this.cachedCost;
    }

    public GeneratedCostProvider generatedProvider(final Function<GeneratorCallback, GristSet> costProvider) {
        return new GeneratedCostProvider(){

            @Override
            @Nullable
            public GristCostResult generate(Item item, GeneratorCallback callback) {
                if (callback.shouldUseSavedResult() && GeneratedGristCostCache.this.hasGeneratedCost) {
                    return GristCostResult.ofOrNull(GeneratedGristCostCache.this.cachedCost);
                }
                GristSet cost = (GristSet)costProvider.apply(callback);
                if (callback.shouldSaveResult()) {
                    GeneratedGristCostCache.this.hasGeneratedCost = true;
                    if (cost != null) {
                        GeneratedGristCostCache.this.cachedCost = cost.asImmutable();
                    }
                }
                return GristCostResult.ofOrNull(cost);
            }
        };
    }
}

