/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class GenerationContext
implements GeneratorCallback {
    private final GenerationContext parent;
    private final Item itemGeneratedFor;
    private final HashMap<Item, GristSet> localCache = new HashMap();
    private final Function<GenerationContext, GristSet> itemLookup;
    private final boolean primary;
    private boolean shouldUseCache;

    GenerationContext(Item itemGeneratedFor, Function<GenerationContext, GristSet> itemLookup) {
        this.parent = null;
        this.itemGeneratedFor = itemGeneratedFor;
        this.itemLookup = itemLookup;
        this.primary = true;
        this.shouldUseCache = true;
    }

    private GenerationContext(Item itemGeneratedFor, GenerationContext parent) {
        this.parent = parent;
        this.itemGeneratedFor = itemGeneratedFor;
        this.localCache.putAll(parent.localCache);
        this.itemLookup = parent.itemLookup;
        this.primary = false;
        this.shouldUseCache = parent.shouldUseCache;
    }

    private GenerationContext nextGeneration(Item itemGeneratedFor) {
        return new GenerationContext(itemGeneratedFor, this);
    }

    private boolean isItemInProcess(Item item) {
        return item == this.getCurrentItem() || this.parent != null && this.parent.isItemInProcess(item);
    }

    private boolean testWithGeneratedItems(Ingredient ingredient) {
        return ingredient.test(new ItemStack((ItemLike)this.itemGeneratedFor)) || this.parent != null && this.parent.testWithGeneratedItems(ingredient);
    }

    public Item getCurrentItem() {
        return this.itemGeneratedFor;
    }

    @Override
    public boolean shouldSaveResult() {
        return this.primary;
    }

    @Override
    public boolean shouldUseSavedResult() {
        return this.shouldUseCache;
    }

    @Override
    public GristSet lookupCostFor(Ingredient ingredient) {
        if (ingredient.test(ItemStack.EMPTY)) {
            return GristSet.EMPTY;
        }
        if (this.testWithGeneratedItems(ingredient)) {
            return null;
        }
        GristSet minCost = null;
        for (ItemStack stack : ingredient.getItems()) {
            GristSet cost;
            if (!ingredient.test(new ItemStack((ItemLike)stack.getItem())) || (cost = this.costWithoutContainer(stack)) == null || minCost != null && !(cost.getValue() < minCost.getValue())) continue;
            minCost = cost;
        }
        return minCost;
    }

    @Override
    public GristSet lookupCostFor(Item item) {
        if (!this.localCache.containsKey(item)) {
            if (this.isItemInProcess(item)) {
                return null;
            }
            GristSet result = this.itemLookup.apply(this.nextGeneration(item));
            this.localCache.put(item, result);
            return result;
        }
        return this.localCache.get(item);
    }

    public GristSet costWithoutContainer(ItemStack stack) {
        ItemStack container;
        GristSet cost = this.lookupCostFor(stack);
        if (cost != null && !(container = stack.getCraftingRemainingItem()).isEmpty()) {
            GristSet containerCost = this.lookupCostFor(container);
            if (containerCost != null) {
                return containerCost.mutableCopy().scale(-1).add(cost);
            }
            return null;
        }
        return cost;
    }

    public <S> S withoutCache(Supplier<S> supplier) {
        if (!this.shouldUseCache) {
            return supplier.get();
        }
        this.shouldUseCache = false;
        HashMap<Item, GristSet> savedCache = new HashMap<Item, GristSet>(this.localCache);
        this.localCache.clear();
        S value = supplier.get();
        this.localCache.putAll(savedCache);
        this.shouldUseCache = true;
        return value;
    }
}

