/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.recipe.generator.GenerationContext;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class GristCostGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static RecipeManager recipes;

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        recipes = event.getServerResources().getRecipeManager();
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        recipes = null;
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            if (recipes != null) {
                GristCostGenerator.run(recipes);
            } else {
                LOGGER.error("Failed to access recipe manager for grist cost generation!");
            }
        }
    }

    private static void run(RecipeManager recipeManager) {
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Starting grist cost generation");
        GeneratorProcess process = new GeneratorProcess();
        List recipeHolders = recipeManager.getAllRecipesFor(GristCostRecipe.RECIPE_TYPE.get());
        for (RecipeHolder holder2 : recipeHolders.stream().sorted(Comparator.comparingInt(holder -> -((GristCostRecipe)holder.value()).getPriority())).toList()) {
            ((GristCostRecipe)holder2.value()).addCostProvider((item, provider) -> {
                process.providersByItem.computeIfAbsent((Item)item, i -> new ArrayList()).add(provider);
                process.providers.add((GeneratedCostProvider)provider);
            }, holder2.id());
        }
        Object2IntOpenHashMap lookupCount = new Object2IntOpenHashMap();
        for (GeneratedCostProvider provider2 : process.providers) {
            provider2.reportPreliminaryLookups(arg_0 -> GristCostGenerator.lambda$run$3((Object2IntMap)lookupCount, arg_0));
        }
        process.providersByItem.keySet().stream().sorted(Comparator.comparingInt(arg_0 -> GristCostGenerator.lambda$run$4((Object2IntMap)lookupCount, arg_0))).forEach(item -> {
            long itemStartTime = System.currentTimeMillis();
            GristCostGenerator.lookupCost(process, new GenerationContext((Item)item, context1 -> GristCostGenerator.lookupCost(process, context1)));
            double itemTime = (double)(System.currentTimeMillis() - itemStartTime) / 1000.0;
            if (itemTime > 0.5) {
                LOGGER.warn("Cost generation for {} took {}s", (Object)BuiltInRegistries.ITEM.getKey(item), (Object)itemTime);
            }
        });
        for (GeneratedCostProvider provider2 : process.providers) {
            try {
                provider2.build();
            }
            catch (Exception e) {
                LOGGER.error("Got exception while building generated cost provider {}:", (Object)provider2, (Object)e);
            }
        }
        LOGGER.info("Finished grist cost generation in {}s", (Object)((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    private static GristSet lookupCost(GeneratorProcess process, GenerationContext context) {
        Item item = context.getCurrentItem();
        GristCostResult cost = null;
        List providers = process.providersByItem.getOrDefault(item, Collections.emptyList());
        for (GeneratedCostProvider provider : providers) {
            try {
                if (cost == null) {
                    cost = provider.generate(item, context);
                    continue;
                }
                provider.onCostFromOtherRecipe(item, cost, context);
            }
            catch (Exception e) {
                LOGGER.error("Got exception from generated cost provider {} while generating for item {}:", (Object)provider, (Object)item, (Object)e);
            }
        }
        if (providers.isEmpty() && ((Boolean)MinestuckConfig.COMMON.logIngredientItemsWithoutCosts.get()).booleanValue()) {
            LOGGER.info("Item {} was looked up, but it did not have any grist costs or recipes.", (Object)BuiltInRegistries.ITEM.getKey((Object)item));
        }
        return cost != null ? cost.cost() : null;
    }

    private static /* synthetic */ int lambda$run$4(Object2IntMap lookupCount, Item item) {
        return -lookupCount.getInt((Object)item);
    }

    private static /* synthetic */ void lambda$run$3(Object2IntMap lookupCount, Item item) {
        lookupCount.mergeInt((Object)item, 1, Integer::sum);
    }

    private static class GeneratorProcess {
        private final Map<Item, List<GeneratedCostProvider>> providersByItem = new HashMap<Item, List<GeneratedCostProvider>>();
        private final Set<GeneratedCostProvider> providers = new HashSet<GeneratedCostProvider>();

        private GeneratorProcess() {
        }
    }
}

