/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.GeneratedGristCostCache;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SourceGristCost
implements GristCostRecipe {
    private final Ingredient ingredient;
    private final List<Source> sources;
    private final float multiplier;
    private final GristSet.Immutable addedCost;
    @Nullable
    private final Integer priority;
    private final GeneratedGristCostCache cache = new GeneratedGristCostCache();

    public SourceGristCost(Ingredient ingredient, List<Source> sources, float multiplier, GristSet.Immutable addedCost, Optional<Integer> priority) {
        this.ingredient = ingredient;
        this.sources = sources;
        this.multiplier = multiplier;
        this.addedCost = addedCost;
        this.priority = priority.orElse(null);
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.cache.getCachedCost() != null && this.ingredient.test(input.item());
    }

    @Override
    public int getPriority() {
        return Objects.requireNonNullElseGet(this.priority, () -> GristCostRecipe.defaultPriority(this.ingredient));
    }

    @Nullable
    private GristSet generateCost(GeneratorCallback callback, List<Source> sources, float multiplier, GristSet.Immutable addedCost) {
        MutableGristSet costSum = MutableGristSet.newDefault();
        for (Source source : sources) {
            GristSet sourceCost = source.getCostFor(callback);
            if (sourceCost != null) {
                costSum.add(sourceCost);
                continue;
            }
            return null;
        }
        return costSum.scale(multiplier, false).add(addedCost);
    }

    @Override
    public GristSet getGristCost(ItemStack input, @Nullable GristType wildcardType, boolean shouldRoundDown) {
        return GristCostRecipe.scaleToCountAndDurability(this.cache.getCachedCost(), input, shouldRoundDown);
    }

    @Override
    public void addCostProvider(BiConsumer<Item, GeneratedCostProvider> consumer, ResourceLocation recipeId) {
        GristCostRecipe.addCostProviderForIngredient(consumer, this.ingredient, this.cache.generatedProvider(callback -> this.generateCost((GeneratorCallback)callback, this.sources, this.multiplier, this.addedCost)));
    }

    @Override
    public List<JeiGristCost> getJeiCosts(Level level) {
        if (this.cache.getCachedCost() != null) {
            return Collections.singletonList(new JeiGristCost.Set(this.ingredient, this.cache.getCachedCost()));
        }
        return Collections.emptyList();
    }

    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.SOURCE_GRIST_COST.get();
    }

    public static sealed interface Source
    permits ItemSource, TagSource {
        public static final Codec<Source> CODEC = Codec.STRING.comapFlatMap(name -> name.startsWith("#") ? ResourceLocation.read((String)name.substring(1)).map(TagSource::new) : ResourceLocation.read((String)name).map(ItemSource::new), (Function<Source, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/mraof/minestuck/alchemy/recipe/generator/SourceGristCost$Source;)Ljava/lang/String;)());

        @Nullable
        public GristSet getCostFor(GeneratorCallback var1);
    }

    public record TagSource(TagKey<Item> tag) implements Source
    {
        private TagSource(ResourceLocation name) {
            this((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)name));
        }

        @Override
        public GristSet getCostFor(GeneratorCallback callback) {
            GristSet maxCost = null;
            for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                GristSet cost = callback.lookupCostFor((Item)item.value());
                if (cost == null || maxCost != null && !(cost.getValue() > maxCost.getValue())) continue;
                maxCost = cost;
            }
            return maxCost;
        }

        @Override
        public String toString() {
            return "#" + String.valueOf(this.tag.location());
        }
    }

    public record ItemSource(Item item) implements Source
    {
        private ItemSource(ResourceLocation name) {
            this((Item)BuiltInRegistries.ITEM.get(name));
        }

        @Override
        public GristSet getCostFor(GeneratorCallback callback) {
            return callback.lookupCostFor(this.item);
        }

        @Override
        public String toString() {
            return BuiltInRegistries.ITEM.getKey((Object)this.item).toString();
        }
    }

    public static class Serializer
    implements RecipeSerializer<SourceGristCost> {
        private static final MapCodec<SourceGristCost> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Source.CODEC.listOf().fieldOf("sources").forGetter(recipe -> recipe.sources), (App)Codec.FLOAT.optionalFieldOf("multiplier", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.multiplier)), (App)GristSet.Codecs.MAP_CODEC.fieldOf("grist_cost").forGetter(recipe -> recipe.addedCost), (App)Codec.INT.optionalFieldOf("priority").forGetter(recipe -> Optional.ofNullable(recipe.priority))).apply((Applicative)instance, SourceGristCost::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SourceGristCost> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SourceGristCost> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SourceGristCost> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SourceGristCost recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeInt(recipe.getPriority());
            recipe.cache.toNetwork(buffer);
        }

        private static SourceGristCost fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int priority = buffer.readInt();
            SourceGristCost recipe = new SourceGristCost(ingredient, Collections.emptyList(), 1.0f, GristSet.EMPTY, Optional.of(priority));
            recipe.cache.fromNetwork(buffer);
            return recipe;
        }
    }
}

