/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator.recipe;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public enum DefaultInterpreter implements RecipeInterpreter
{
    INSTANCE;

    public static final MapCodec<DefaultInterpreter> CODEC;

    @Override
    public List<Item> getOutputItems(Recipe<?> recipe) {
        ItemStack stack = recipe.getResultItem(null);
        return stack.isEmpty() ? Collections.emptyList() : Collections.singletonList(stack.getItem());
    }

    @Override
    public MutableGristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        if (recipe.isSpecial()) {
            return null;
        }
        MutableGristSet totalCost = MutableGristSet.newDefault();
        for (Ingredient ingredient : recipe.getIngredients()) {
            GristSet ingredientCost = callback.lookupCostFor(ingredient);
            if (ingredientCost == null) {
                return null;
            }
            totalCost.add(ingredientCost);
        }
        totalCost.scale(1.0f / (float)recipe.getResultItem(null).getCount(), false);
        return totalCost;
    }

    @Override
    public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
        recipe.getIngredients().forEach(tracker::report);
    }

    @Override
    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    static {
        CODEC = MapCodec.unit((Object)INSTANCE);
    }
}

