/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedCostProcess;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedGristCost;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeSource;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class RecipeGeneratedCostHandler
extends SimplePreparableReloadListener<List<SourceEntry>>
implements GeneratedCostProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PATH = "minestuck/grist_cost_generation_recipes.json";
    private final RecipeManager recipeManager;
    private Map<Item, GristSet.Immutable> generatedCosts = Collections.emptyMap();
    private RecipeGeneratedCostProcess process = null;

    private RecipeGeneratedCostHandler(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    private RecipeGeneratedCostHandler(Map<Item, GristSet.Immutable> generatedCosts) {
        this.recipeManager = null;
        this.generatedCosts = generatedCosts;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeGeneratedCostHandler(event.getServerResources().getRecipeManager()));
    }

    public Map<Item, GristSet.Immutable> getMap() {
        return this.generatedCosts;
    }

    void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.generatedCosts.size());
        for (Map.Entry<Item, GristSet.Immutable> entry : this.generatedCosts.entrySet()) {
            buffer.writeVarInt(Item.getId((Item)entry.getKey()));
            GristSet.Codecs.STREAM_CODEC.encode((Object)buffer, (Object)entry.getValue());
        }
    }

    @Nullable
    static RecipeGeneratedCostHandler read(RegistryFriendlyByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            return null;
        }
        int size = buffer.readInt();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (int i = 0; i < size; ++i) {
            Item item = Item.byId((int)buffer.readVarInt());
            GristSet.Immutable cost = (GristSet.Immutable)GristSet.Codecs.STREAM_CODEC.decode((Object)buffer);
            builder.put((Object)item, (Object)cost);
        }
        return new RecipeGeneratedCostHandler((Map<Item, GristSet.Immutable>)builder.build());
    }

    List<JeiGristCost> createJeiCosts() {
        ArrayList<JeiGristCost> costs = new ArrayList<JeiGristCost>();
        for (Map.Entry<Item, GristSet.Immutable> entries : this.generatedCosts.entrySet()) {
            if (entries.getValue() == null) continue;
            costs.add(new JeiGristCost.Set(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)entries.getKey()}), entries.getValue()));
        }
        return costs;
    }

    protected List<SourceEntry> prepare(ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ArrayList<SourceEntry> sources = new ArrayList<SourceEntry>();
        for (String namespace : resourceManagerIn.getNamespaces()) {
            resourceManagerIn.getResource(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)PATH)).ifPresent(resource -> {
                try (BufferedReader reader = resource.openAsReader();){
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    SourceEntry.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(sources::addAll);
                }
                catch (Exception runtimeexception) {
                    LOGGER.warn("Unable to load grist_cost_generation.json in data pack: '{}'", (Object)resource.sourcePackId(), (Object)runtimeexception);
                }
            });
        }
        return sources;
    }

    protected void apply(List<SourceEntry> sources, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        Objects.requireNonNull(this.recipeManager, "Recipe manager was null while generating grist costs");
        if (sources.size() != 0 && this.recipeManager.getRecipes().size() == 0) {
            throw new IllegalStateException("Grist cost generator is supposed to be executed on server thread after initializing. The failure of this assertion is not good!");
        }
        this.process = new RecipeGeneratedCostProcess(this.prepareRecipeMap(sources, this.recipeManager));
        for (RecipeHolder holder : this.recipeManager.getRecipes()) {
            Recipe recipe = holder.value();
            if (!(recipe instanceof RecipeGeneratedGristCost)) continue;
            RecipeGeneratedGristCost recipe2 = (RecipeGeneratedGristCost)recipe;
            recipe2.setHandler(this);
            return;
        }
        this.process = null;
        if (!sources.isEmpty()) {
            LOGGER.warn("Did not find a recipe for recipe generated grist costs. Grist costs will not be generated!");
        }
    }

    void addAsProvider(BiConsumer<Item, GeneratedCostProvider> consumer) {
        for (Item item : this.process.itemSet()) {
            consumer.accept(item, this);
        }
    }

    @Override
    public GristCostResult generate(Item item, GeneratorCallback callback) {
        return this.process.generateCost(item, callback);
    }

    @Override
    public void onCostFromOtherRecipe(Item item, GristCostResult lastCost, GeneratorCallback callback) {
        this.process.onCostFromOtherRecipe(item, lastCost, callback);
    }

    @Override
    public void build() {
        if (this.process == null) {
            throw new IllegalStateException("Tried to build recipe-generated costs, but did not have an ongoing process!");
        }
        this.generatedCosts = this.process.buildMap();
        this.process = null;
        LOGGER.info("Generated {} grist conversions from recipes.", (Object)this.generatedCosts.size());
    }

    @Override
    public void reportPreliminaryLookups(LookupTracker tracker) {
        this.process.reportPreliminaryLookups(tracker);
    }

    private Map<Item, List<Pair<RecipeHolder<?>, RecipeInterpreter>>> prepareRecipeMap(List<SourceEntry> sources, RecipeManager recipeManager) {
        ArrayList<Pair> recipeLists = new ArrayList<Pair>(sources.size());
        for (SourceEntry sourceEntry : sources) {
            Collection<RecipeHolder<?>> recipes = sourceEntry.source.findRecipes(recipeManager);
            recipeLists.add(Pair.of(recipes, (Object)sourceEntry.interpreter));
        }
        recipeLists.sort(Comparator.comparingInt(pair -> -((Collection)pair.getLeft()).size()));
        HashMap<RecipeHolder, RecipeInterpreter> recipeMap = new HashMap<RecipeHolder, RecipeInterpreter>();
        for (Pair pair2 : recipeLists) {
            for (RecipeHolder recipe : (Collection)pair2.getLeft()) {
                recipeMap.put(recipe, (RecipeInterpreter)pair2.getRight());
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : recipeMap.entrySet()) {
            for (Item item : ((RecipeInterpreter)entry.getValue()).getOutputItems(((RecipeHolder)entry.getKey()).value())) {
                hashMap.computeIfAbsent(item, item1 -> new ArrayList()).add(Pair.of((Object)((RecipeHolder)entry.getKey()), (Object)((RecipeInterpreter)entry.getValue())));
            }
        }
        return hashMap;
    }

    public record SourceEntry(RecipeSource source, RecipeInterpreter interpreter) {
        public static final Codec<SourceEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecipeSource.DISPATCH_CODEC.fieldOf("source").forGetter(SourceEntry::source), (App)RecipeInterpreter.DISPATCH_CODEC.fieldOf("interpreter").forGetter(SourceEntry::interpreter)).apply((Applicative)instance, SourceEntry::new));
        public static final Codec<List<SourceEntry>> LIST_CODEC = CODEC.listOf();
    }
}

