/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator.recipe;

import com.google.common.collect.ImmutableMap;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.recipe.generator.GenerationContext;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RecipeGeneratedCostProcess {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Item, List<Pair<RecipeHolder<?>, RecipeInterpreter>>> lookupMap;
    private final Map<Item, GristSet.Immutable> generatedCosts = new HashMap<Item, GristSet.Immutable>();

    RecipeGeneratedCostProcess(Map<Item, List<Pair<RecipeHolder<?>, RecipeInterpreter>>> lookupMap) {
        this.lookupMap = lookupMap;
    }

    Map<Item, GristSet.Immutable> buildMap() {
        this.generatedCosts.entrySet().removeIf(entry -> entry.getValue() == null);
        return ImmutableMap.copyOf(this.generatedCosts);
    }

    Set<Item> itemSet() {
        return this.lookupMap.keySet();
    }

    void reportPreliminaryLookups(LookupTracker tracker) {
        for (List<Pair<RecipeHolder<?>, RecipeInterpreter>> recipes : this.lookupMap.values()) {
            for (Pair<RecipeHolder<?>, RecipeInterpreter> recipe : recipes) {
                ((RecipeInterpreter)recipe.getValue()).reportPreliminaryLookups(((RecipeHolder)recipe.getKey()).value(), tracker);
            }
        }
    }

    GristCostResult generateCost(Item item, GeneratorCallback callback) {
        if (this.generatedCosts.containsKey(item)) {
            return GristCostResult.ofOrNull(this.generatedCosts.get(item));
        }
        GristSet result = this.removeZeros(this.costFromRecipes(item, callback));
        if (result != null && result.isEmpty()) {
            result = null;
            LOGGER.debug("Found item {} with valid recipe but no grist cost", (Object)item);
        }
        if (callback.shouldSaveResult()) {
            this.generatedCosts.put(item, result == null ? null : result.asImmutable());
        }
        return GristCostResult.ofOrNull(result);
    }

    void onCostFromOtherRecipe(Item item, GristCostResult lastCost, GeneratorCallback callback) {
        if (callback.shouldSaveResult()) {
            this.checkRecipeLogging(item, lastCost.cost(), (GenerationContext)callback);
        }
    }

    private GristSet costFromRecipes(Item item, GeneratorCallback callback) {
        List recipes = this.lookupMap.getOrDefault(item, Collections.emptyList());
        if (!recipes.isEmpty()) {
            GristSet minCost = null;
            for (Pair recipePair : recipes) {
                GristSet cost = this.costForRecipe((RecipeHolder)recipePair.getLeft(), (RecipeInterpreter)recipePair.getRight(), item, callback);
                if (cost == null || minCost != null && !(cost.getValue() < minCost.getValue())) continue;
                minCost = cost;
            }
            return minCost;
        }
        return null;
    }

    private GristSet costForRecipe(RecipeHolder<?> recipe, RecipeInterpreter interpreter, Item item, GeneratorCallback callback) {
        try {
            return interpreter.generateCost(recipe.value(), item, callback);
        }
        catch (Exception e) {
            LOGGER.error("Got exception while getting cost for recipe {}", (Object)recipe.id(), (Object)e);
            return null;
        }
    }

    private void checkRecipeLogging(Item item, GristSet cost, GenerationContext context) {
        GristSet generatedCost;
        if (((Boolean)MinestuckConfig.COMMON.logItemsWithRecipeAndCost.get()).booleanValue() && (generatedCost = context.withoutCache(() -> this.costFromRecipes(item, context))) != null) {
            if (generatedCost.getValue() < cost.getValue()) {
                LOGGER.warn("Found item {} with grist cost recipe greater than a potential generated grist cost. Recipe cost: {}, generated cost: {}", (Object)item, (Object)cost, (Object)generatedCost);
            } else {
                LOGGER.info("Found item {} with grist cost recipe that is also valid for grist cost generation. Recipe cost: {}, generated cost: {}", (Object)item, (Object)cost, (Object)generatedCost);
            }
        }
    }

    private GristSet removeZeros(GristSet gristSet) {
        if (gristSet == null) {
            return null;
        }
        MutableGristSet nonZeros = MutableGristSet.newDefault();
        for (GristAmount amount : gristSet.asAmounts()) {
            if (amount.amount() == 0L) continue;
            nonZeros.add(amount);
        }
        return nonZeros;
    }
}

