/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

@MethodsReturnNonnullByDefault
public sealed interface RecipeSource {
    public static final Codec<RecipeSource> DISPATCH_CODEC = Type.CODEC.dispatch(RecipeSource::type, type -> type.sourceCodec.get());

    public Collection<RecipeHolder<?>> findRecipes(RecipeManager var1);

    public Type type();

    public static enum Type implements StringRepresentable
    {
        RECIPE(() -> SingleRecipe.CODEC),
        RECIPE_SERIALIZER(() -> BySerializer.CODEC),
        RECIPE_TYPE(() -> ByType.CODEC);

        static final Codec<Type> CODEC;
        private final Supplier<MapCodec<? extends RecipeSource>> sourceCodec;

        private Type(Supplier<MapCodec<? extends RecipeSource>> sourceCodec) {
            this.sourceCodec = sourceCodec;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record ByType(RecipeType<?> recipeType) implements RecipeSource
    {
        static final MapCodec<ByType> CODEC = BuiltInRegistries.RECIPE_TYPE.byNameCodec().fieldOf("recipe_type").xmap(ByType::new, ByType::recipeType);

        public List<RecipeHolder<?>> findRecipes(RecipeManager recipeManager) {
            return recipeManager.getRecipes().stream().filter(recipeHolder -> recipeHolder.value().getType() == this.recipeType).toList();
        }

        @Override
        public Type type() {
            return Type.RECIPE_TYPE;
        }

        @Override
        public String toString() {
            return "recipe_source[type=" + String.valueOf(this.recipeType) + "]";
        }
    }

    public record BySerializer(RecipeSerializer<?> serializer) implements RecipeSource
    {
        static final MapCodec<BySerializer> CODEC = BuiltInRegistries.RECIPE_SERIALIZER.byNameCodec().fieldOf("serializer").xmap(BySerializer::new, BySerializer::serializer);

        @Override
        public Collection<RecipeHolder<?>> findRecipes(RecipeManager recipeManager) {
            return recipeManager.getRecipes().stream().filter(recipeHolder -> recipeHolder.value().getSerializer() == this.serializer).toList();
        }

        @Override
        public Type type() {
            return Type.RECIPE_SERIALIZER;
        }

        @Override
        public String toString() {
            return "recipe_source[serializer=" + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.serializer)) + "]";
        }
    }

    public record SingleRecipe(ResourceLocation recipe) implements RecipeSource
    {
        static final MapCodec<SingleRecipe> CODEC = ResourceLocation.CODEC.fieldOf("recipe").xmap(SingleRecipe::new, SingleRecipe::recipe);

        @Override
        public Collection<RecipeHolder<?>> findRecipes(RecipeManager recipeManager) {
            Optional recipe = recipeManager.byKey(this.recipe);
            return recipe.map(Collections::singleton).orElse(Collections.emptySet());
        }

        @Override
        public Type type() {
            return Type.RECIPE;
        }

        @Override
        public String toString() {
            return "recipe_source[recipe=" + String.valueOf(this.recipe) + "]";
        }
    }
}

