/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe.generator.recipe;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public enum SmithingInterpreter implements RecipeInterpreter
{
    INSTANCE;

    public static final MapCodec<SmithingInterpreter> CODEC;
    private static final Field templateField;
    private static final Field baseField;
    private static final Field additionField;

    @Override
    public List<Item> getOutputItems(Recipe<?> recipe) {
        ItemStack stack = recipe.getResultItem(null);
        return stack.isEmpty() ? Collections.emptyList() : Collections.singletonList(stack.getItem());
    }

    @Override
    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        try {
            MutableGristSet totalCost = MutableGristSet.newDefault();
            Ingredient template = (Ingredient)templateField.get(recipe);
            GristSet templateCost = callback.lookupCostFor(template);
            if (templateCost == null) {
                return null;
            }
            totalCost.add(templateCost);
            Ingredient base = (Ingredient)baseField.get(recipe);
            GristSet baseCost = callback.lookupCostFor(base);
            if (baseCost == null) {
                return null;
            }
            totalCost.add(baseCost);
            Ingredient addition = (Ingredient)additionField.get(recipe);
            GristSet additionCost = callback.lookupCostFor(addition);
            if (additionCost == null) {
                return null;
            }
            totalCost.add(additionCost);
            totalCost.scale(1.0f / (float)recipe.getResultItem(null).getCount(), false);
            return totalCost;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    static {
        CODEC = MapCodec.unit((Object)INSTANCE);
        templateField = ObfuscationReflectionHelper.findField(SmithingTransformRecipe.class, (String)"template");
        baseField = ObfuscationReflectionHelper.findField(SmithingTransformRecipe.class, (String)"base");
        additionField = ObfuscationReflectionHelper.findField(SmithingTransformRecipe.class, (String)"addition");
    }
}

