/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.google.common.collect.ImmutableMap;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import java.util.List;
import java.util.Map;

public final class DefaultImmutableGristSet
implements GristSet.Immutable {
    private final ImmutableMap<GristType, Long> map;

    public DefaultImmutableGristSet(GristSet set) {
        this(set.asMap());
    }

    public DefaultImmutableGristSet(Map<GristType, Long> grist) {
        this.map = ImmutableMap.copyOf(grist);
    }

    public DefaultImmutableGristSet(ImmutableMap.Builder<GristType, Long> builder) {
        this.map = builder.build();
    }

    public static GristSet.Immutable create(List<GristAmount> amounts) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GristAmount gristAmount : amounts) {
            builder.put((Object)gristAmount.type(), (Object)gristAmount.amount());
        }
        return new DefaultImmutableGristSet((ImmutableMap.Builder<GristType, Long>)builder);
    }

    @Override
    public Map<GristType, Long> asMap() {
        return this.map;
    }
}

