/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class DefaultMutableGristSet
implements MutableGristSet {
    private final Map<GristType, Long> gristMap = new TreeMap<GristType, Long>();
    private final Map<GristType, Long> mapView = Collections.unmodifiableMap(this.gristMap);

    public DefaultMutableGristSet() {
    }

    public DefaultMutableGristSet(GristSet set) {
        this(set.asAmounts());
    }

    public DefaultMutableGristSet(Iterable<GristAmount> amounts) {
        for (GristAmount amount : amounts) {
            this.set(amount.type(), amount.amount());
        }
    }

    @Override
    public Map<GristType, Long> asMap() {
        return this.mapView;
    }

    @Override
    public MutableGristSet set(GristType type, long amount) {
        Objects.requireNonNull(type);
        this.gristMap.put(type, amount);
        return this;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append("gristSet:[");
        boolean first = true;
        for (Map.Entry<GristType, Long> entry : this.gristMap.entrySet()) {
            if (!first) {
                build.append(',');
            }
            build.append(entry.getKey()).append("=").append(entry.getValue());
            first = false;
        }
        build.append(']');
        return build.toString();
    }
}

