/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record GristAmount(GristType type, long amount) implements GristSet.Immutable
{
    public static final Codec<GristAmount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GristTypes.REGISTRY.byNameCodec().fieldOf("type").forGetter(GristAmount::type), (App)Codec.LONG.fieldOf("amount").forGetter(GristAmount::amount)).apply((Applicative)instance, GristAmount::new));
    public static final Codec<List<GristAmount>> LIST_CODEC = CODEC.listOf();
    public static final Codec<GristAmount> NON_NEGATIVE_CODEC = CODEC.comapFlatMap(GristAmount::checkNonNegative, Function.identity());
    public static final Codec<List<GristAmount>> NON_NEGATIVE_LIST_CODEC = NON_NEGATIVE_CODEC.listOf();
    public static final String GRIST_AMOUNT = "grist_amount";
    public static final StreamCodec<RegistryFriendlyByteBuf, GristAmount> STREAM_CODEC = StreamCodec.composite(GristType.STREAM_CODEC, GristAmount::type, (StreamCodec)ByteBufCodecs.VAR_LONG, GristAmount::amount, GristAmount::new);

    public GristAmount(Supplier<GristType> type, long amount) {
        this(type.get(), amount);
    }

    private static DataResult<GristAmount> checkNonNegative(GristAmount gristAmount) {
        if (gristAmount.amount >= 0L) {
            return DataResult.success((Object)gristAmount);
        }
        return DataResult.error(() -> "Negative amount %s for grist type %s".formatted(gristAmount.amount, gristAmount.type));
    }

    @Override
    public long getGrist(GristType type) {
        return this.type == type ? this.amount : 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0L;
    }

    @Override
    public boolean hasType(GristType type) {
        return this.type == type;
    }

    @Override
    public double getValue() {
        return this.type.getValue() * (float)this.amount;
    }

    @Override
    public Map<GristType, Long> asMap() {
        return Map.of(this.type, this.amount);
    }

    @Override
    public List<GristAmount> asAmounts() {
        return Collections.singletonList(this);
    }

    @Override
    public Component asTextComponent() {
        return Component.translatable((String)GRIST_AMOUNT, (Object[])new Object[]{this.amount(), this.type().getDisplayName()});
    }
}

