/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.api.alchemy.DefaultImmutableGristSet;
import com.mraof.minestuck.api.alchemy.DefaultMutableGristSet;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface GristSet {
    public static final String GRIST_COMMA = "grist.comma";
    public static final Immutable EMPTY = Collections::emptyMap;

    default public long getGrist(GristType type) {
        return this.asMap().getOrDefault(type, 0L);
    }

    default public boolean hasType(GristType type) {
        return this.asMap().containsKey(type);
    }

    default public boolean isEmpty() {
        return this.asMap().values().stream().allMatch(amount -> amount == 0L);
    }

    default public boolean equalContent(GristSet other) {
        for (GristType type : GristTypes.REGISTRY) {
            if (this.getGrist(type) == other.getGrist(type)) continue;
            return false;
        }
        return true;
    }

    default public double getValue() {
        double sum = 0.0;
        for (GristAmount amount : this.asAmounts()) {
            sum += amount.getValue();
        }
        return sum;
    }

    public Map<GristType, Long> asMap();

    public Immutable asImmutable();

    default public MutableGristSet mutableCopy() {
        return new DefaultMutableGristSet(this);
    }

    default public List<GristAmount> asAmounts() {
        return this.asMap().entrySet().stream().map(entry -> new GristAmount((GristType)entry.getKey(), (long)((Long)entry.getValue()))).toList();
    }

    default public Component asTextComponent() {
        Component component = null;
        for (GristAmount grist : this.asAmounts()) {
            if (component == null) {
                component = grist.asTextComponent();
                continue;
            }
            component = Component.translatable((String)GRIST_COMMA, (Object[])new Object[]{component, grist.asTextComponent()});
        }
        if (component != null) {
            return component;
        }
        return Component.empty();
    }

    public static Immutable of(GristAmount ... amounts) {
        if (amounts.length == 0) {
            return EMPTY;
        }
        if (amounts.length == 1) {
            return amounts[0];
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GristAmount amount : amounts) {
            builder.put((Object)amount.type(), (Object)amount.amount());
        }
        return new DefaultImmutableGristSet((ImmutableMap.Builder<GristType, Long>)builder);
    }

    public static interface Immutable
    extends GristSet {
        @Override
        default public Immutable asImmutable() {
            return this;
        }
    }

    public static final class Codecs {
        public static final Codec<Immutable> NON_NEGATIVE_CODEC = GristAmount.NON_NEGATIVE_LIST_CODEC.xmap(DefaultImmutableGristSet::create, GristSet::asAmounts);
        public static final Codec<Immutable> MAP_CODEC = Codec.unboundedMap((Codec)GristTypes.REGISTRY.byNameCodec(), (Codec)Codec.LONG).xmap(DefaultImmutableGristSet::new, GristSet::asMap);
        public static final Codec<Immutable> LIST_CODEC = GristAmount.LIST_CODEC.xmap(DefaultImmutableGristSet::create, GristSet::asAmounts);
        public static final StreamCodec<RegistryFriendlyByteBuf, Immutable> STREAM_CODEC = StreamCodec.composite((StreamCodec)GristAmount.STREAM_CODEC.apply(ByteBufCodecs.list()), GristSet::asAmounts, DefaultImmutableGristSet::create);
    }
}

