/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public final class GristType
implements Comparable<GristType> {
    public static final StreamCodec<RegistryFriendlyByteBuf, GristType> STREAM_CODEC = ByteBufCodecs.registry(GristTypes.REGISTRY_KEY);
    public static final Codec<GristType> CODEC = GristTypes.REGISTRY.byNameCodec();
    public static final ResourceLocation DUMMY_ID = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"dummy");
    public static final ResourceLocation DUMMY_ICON_LOCATION = GristType.makeIconPath(DUMMY_ID);
    public static final String FORMAT = "grist.format";
    private final float rarity;
    private final float value;
    private final Supplier<ItemStack> candyItem;
    @Nullable
    private final UnderlingData underlingData;
    @Nullable
    private final ResourceLocation textureOverrideId;
    private final Supplier<String> translationKey = Suppliers.memoize(() -> Util.makeDescriptionId((String)"grist", (ResourceLocation)this.getId()));
    private final Supplier<ResourceLocation> icon = Suppliers.memoize(() -> GristType.makeIconPath(this.getTextureId()));

    public GristType(Properties properties) {
        this.rarity = properties.rarity;
        this.value = properties.value;
        this.candyItem = properties.candyItem;
        this.underlingData = properties.underlingData;
        this.textureOverrideId = properties.textureOverrideId;
    }

    public GristAmount amount(long amount) {
        return new GristAmount(this, amount);
    }

    @Nullable
    public ResourceLocation getId() {
        return GristTypes.REGISTRY.getKey((Object)this);
    }

    public ResourceLocation getIdOrThrow() {
        return Objects.requireNonNull(this.getId());
    }

    public Component getNameWithSuffix() {
        return Component.translatable((String)FORMAT, (Object[])new Object[]{this.getDisplayName()});
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return this.translationKey.get();
    }

    public float getRarity() {
        return this.rarity;
    }

    public float getPower() {
        return this.underlingData != null ? this.underlingData.power : 0.0f;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isUnderlingType() {
        return this.underlingData != null;
    }

    public ResourceLocation getIcon() {
        return this.icon.get();
    }

    public ResourceLocation getTextureId() {
        if (this.textureOverrideId != null) {
            return this.textureOverrideId;
        }
        return Objects.requireNonNullElse(this.getId(), DUMMY_ID);
    }

    public ItemStack getCandyItem() {
        return this.candyItem.get();
    }

    public Optional<HolderSet.Named<GristType>> getSecondaryTypes() {
        return GristTypes.REGISTRY.getTag(this.getSecondaryTypesTag());
    }

    public TagKey<GristType> getSecondaryTypesTag() {
        return TagKey.create(GristTypes.REGISTRY_KEY, (ResourceLocation)this.getIdOrThrow().withPrefix("secondary/"));
    }

    public int getUnderlingColor() {
        return this.underlingData != null ? this.underlingData.color : 0xFFFFFF;
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    @Override
    public int compareTo(GristType gristType) {
        if (this.rarity > gristType.rarity) {
            return -1;
        }
        if (this.rarity < gristType.rarity) {
            return 1;
        }
        return this.getIdOrThrow().getPath().compareTo(gristType.getIdOrThrow().getPath());
    }

    private static ResourceLocation makeIconPath(ResourceLocation textureId) {
        return textureId.withPath(arg_0 -> GristType.lambda$makeIconPath$2("textures/grist/%s.png", arg_0));
    }

    private static /* synthetic */ String lambda$makeIconPath$2(String rec$, Object xva$0) {
        return "textures/grist/%s.png".formatted(xva$0);
    }

    public static final class Properties {
        private final float rarity;
        private final float value;
        private Supplier<ItemStack> candyItem = () -> ItemStack.EMPTY;
        @Nullable
        private UnderlingData underlingData = null;
        @Nullable
        private ResourceLocation textureOverrideId = null;

        public Properties(float rarity, float value) {
            this.rarity = rarity;
            this.value = value;
        }

        public Properties candy(Supplier<Item> item) {
            Objects.requireNonNull(item);
            return this.candyStack(() -> new ItemStack((ItemLike)item.get()));
        }

        public Properties candyStack(Supplier<ItemStack> stack) {
            this.candyItem = Objects.requireNonNull(stack);
            return this;
        }

        public Properties underlingType(int color) {
            return this.underlingType(1.0f / this.rarity, color);
        }

        public Properties underlingType(float power, int color) {
            this.underlingData = new UnderlingData(color, power);
            return this;
        }

        public Properties textureOverride(ResourceLocation textureOverrideId) {
            this.textureOverrideId = textureOverrideId;
            return this;
        }
    }

    private record UnderlingData(int color, float power) {
    }
}

