/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.api.alchemy.DefaultImmutableGristSet;
import com.mraof.minestuck.api.alchemy.DefaultMutableGristSet;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import java.util.function.Supplier;

public interface MutableGristSet
extends GristSet {
    public static final Codec<MutableGristSet> CODEC = GristAmount.LIST_CODEC.xmap(DefaultMutableGristSet::new, GristSet::asAmounts);

    public static MutableGristSet newDefault() {
        return new DefaultMutableGristSet();
    }

    @Override
    default public GristSet.Immutable asImmutable() {
        return new DefaultImmutableGristSet(this);
    }

    public MutableGristSet set(GristType var1, long var2);

    default public MutableGristSet add(GristType type, long amount) {
        return this.set(type, this.getGrist(type) + amount);
    }

    default public MutableGristSet add(Supplier<GristType> type, long amount) {
        return this.add(type.get(), amount);
    }

    default public MutableGristSet add(GristSet set) {
        for (GristAmount grist : set.asAmounts()) {
            this.add(grist.type(), grist.amount());
        }
        return this;
    }

    default public MutableGristSet scale(float scale, boolean roundDown) {
        for (GristAmount gristAmount : this.asAmounts()) {
            long amount = gristAmount.amount();
            if (amount == 0L) continue;
            this.set(gristAmount.type(), roundDown ? (long)((float)amount * scale) : (long)MutableGristSet.roundToNonZero((float)amount * scale));
        }
        return this;
    }

    default public MutableGristSet scale(int scale) {
        return this.scale(scale, true);
    }

    private static int roundToNonZero(float value) {
        if (value < 0.0f) {
            return Math.min(-1, Math.round(value));
        }
        return Math.max(1, Math.round(value));
    }
}

