/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.api.alchemy.DefaultMutableGristSet;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import java.util.List;
import java.util.Map;

public final class NonNegativeGristSet
implements MutableGristSet {
    public static Codec<NonNegativeGristSet> CODEC = GristAmount.NON_NEGATIVE_LIST_CODEC.xmap(NonNegativeGristSet::new, GristSet::asAmounts);
    private final DefaultMutableGristSet wrappedSet = new DefaultMutableGristSet();

    public NonNegativeGristSet() {
    }

    public NonNegativeGristSet(GristSet set) {
        this(set.asAmounts());
    }

    public NonNegativeGristSet(List<GristAmount> amounts) {
        for (GristAmount amount : amounts) {
            this.set(amount.type(), amount.amount());
        }
    }

    @Override
    public Map<GristType, Long> asMap() {
        return this.wrappedSet.asMap();
    }

    @Override
    public NonNegativeGristSet set(GristType type, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Negative grist amounts not allowed!");
        }
        this.wrappedSet.set(type, amount);
        return this;
    }
}

