/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy.recipe;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface GristCostRecipe
extends Recipe<SingleRecipeInput> {
    public static final Supplier<RecipeType<GristCostRecipe>> RECIPE_TYPE = MSRecipeTypes.GRIST_COST_TYPE;

    @Nullable
    public static GristSet findCostForItem(ItemStack input, @Nullable GristType wildcardType, boolean shouldRoundDown, Level level) {
        return GristCostRecipe.findRecipeForItem(input, level).map(recipe -> recipe.getGristCost(input, wildcardType, shouldRoundDown)).orElse(null);
    }

    public static Optional<GristCostRecipe> findRecipeForItem(ItemStack input, Level level) {
        return GristCostRecipe.findRecipeForItem(input, level, level.getRecipeManager());
    }

    public static Optional<GristCostRecipe> findRecipeForItem(ItemStack input, Level level, RecipeManager recipeManager) {
        return recipeManager.getRecipesFor(RECIPE_TYPE.get(), (RecipeInput)new SingleRecipeInput(input), level).stream().map(RecipeHolder::value).max(Comparator.comparingInt(GristCostRecipe::getPriority));
    }

    public int getPriority();

    @Nullable
    public GristSet getGristCost(ItemStack var1, @Nullable GristType var2, boolean var3);

    default public boolean canPickWildcard() {
        return false;
    }

    public void addCostProvider(BiConsumer<Item, GeneratedCostProvider> var1, ResourceLocation var2);

    default public List<JeiGristCost> getJeiCosts(Level level) {
        return Collections.emptyList();
    }

    default public RecipeType<GristCostRecipe> getType() {
        return RECIPE_TYPE.get();
    }

    default public ItemStack assemble(SingleRecipeInput inv, HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public boolean isSpecial() {
        return true;
    }

    default public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    public static int defaultPriority(Ingredient ingredient) {
        return 100 - (ingredient.getItems().length - 1) * 10;
    }

    public static void addSimpleCostProvider(BiConsumer<Item, GeneratedCostProvider> consumer, GristCostRecipe recipe, Ingredient ingredient) {
        GristCostRecipe.addCostProviderForIngredient(consumer, ingredient, (item, context) -> new GristCostResult(recipe.getGristCost(new ItemStack((ItemLike)item), GristTypes.BUILD.get(), false)));
    }

    public static void addCostProviderForIngredient(BiConsumer<Item, GeneratedCostProvider> consumer, Ingredient ingredient, GeneratedCostProvider provider) {
        for (ItemStack stack : ingredient.getItems()) {
            consumer.accept(stack.getItem(), provider);
        }
    }

    @Nullable
    public static GristSet scaleToCountAndDurability(@Nullable GristSet cost, ItemStack stack, boolean shouldRoundDown) {
        if (cost == null) {
            return null;
        }
        if (stack.getCount() == 1 && !stack.isDamaged()) {
            return cost;
        }
        MutableGristSet mutableCost = cost.mutableCopy();
        if (stack.getCount() != 1) {
            mutableCost.scale(stack.getCount());
        }
        if (stack.isDamaged()) {
            float multiplier = 1.0f - (float)stack.getItem().getDamage(stack) / (float)stack.getMaxDamage();
            mutableCost.scale(multiplier, shouldRoundDown);
        }
        return mutableCost;
    }
}

