/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy.recipe;

import com.google.common.collect.ImmutableMap;
import com.mraof.minestuck.alchemy.recipe.generator.SourceGristCost;
import com.mraof.minestuck.api.alchemy.DefaultImmutableGristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SourceGristCostBuilder {
    @Nullable
    private final ResourceLocation defaultName;
    private final Ingredient ingredient;
    private final ImmutableMap.Builder<GristType, Long> costBuilder = ImmutableMap.builder();
    private final List<SourceGristCost.Source> sources = new ArrayList<SourceGristCost.Source>();
    private float multiplier = 1.0f;
    @Nullable
    private Integer priority = null;

    public static SourceGristCostBuilder of(TagKey<Item> tag) {
        return new SourceGristCostBuilder(tag.location().withSuffix("_tag"), Ingredient.of(tag));
    }

    public static SourceGristCostBuilder of(ItemLike item) {
        return new SourceGristCostBuilder(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static SourceGristCostBuilder of(Ingredient ingredient) {
        return new SourceGristCostBuilder(null, ingredient);
    }

    private SourceGristCostBuilder(@Nullable ResourceLocation defaultName, Ingredient ingredient) {
        this.defaultName = defaultName;
        this.ingredient = ingredient;
    }

    public SourceGristCostBuilder grist(Supplier<GristType> type, long amount) {
        return this.grist(type.get(), amount);
    }

    public SourceGristCostBuilder grist(GristType type, long amount) {
        this.costBuilder.put((Object)type, (Object)amount);
        return this;
    }

    public SourceGristCostBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public SourceGristCostBuilder source(TagKey<Item> source) {
        this.sources.add(new SourceGristCost.TagSource(source));
        return this;
    }

    public SourceGristCostBuilder source(Item source) {
        this.sources.add(new SourceGristCost.ItemSource(source));
        return this;
    }

    public SourceGristCostBuilder multiplier(float multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public void build(RecipeOutput recipeOutput) {
        ResourceLocation name = Objects.requireNonNull(this.defaultName != null ? this.defaultName : BuiltInRegistries.ITEM.getKey((Object)this.ingredient.getItems()[0].getItem()));
        this.build(recipeOutput, name);
    }

    public void buildFor(RecipeOutput recipeOutput, String modId) {
        ResourceLocation name = Objects.requireNonNull(this.defaultName != null ? this.defaultName : BuiltInRegistries.ITEM.getKey((Object)this.ingredient.getItems()[0].getItem()));
        this.build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)modId, (String)name.getPath()));
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        recipeOutput.accept(id.withPrefix("grist_costs/"), (Recipe)new SourceGristCost(this.ingredient, this.sources, this.multiplier, new DefaultImmutableGristSet(this.costBuilder), Optional.ofNullable(this.priority)), null);
    }
}

