/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy.recipe;

import com.mraof.minestuck.alchemy.recipe.WildcardGristCost;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class WildcardGristCostBuilder {
    @Nullable
    private final ResourceLocation defaultName;
    private final Ingredient ingredient;
    private long cost = 0L;
    @Nullable
    private Integer priority = null;

    public static WildcardGristCostBuilder of(TagKey<Item> tag) {
        return new WildcardGristCostBuilder(tag.location().withSuffix("_tag"), Ingredient.of(tag));
    }

    public static WildcardGristCostBuilder of(ItemLike item) {
        return new WildcardGristCostBuilder(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public static WildcardGristCostBuilder of(Ingredient ingredient) {
        return new WildcardGristCostBuilder(null, ingredient);
    }

    private WildcardGristCostBuilder(@Nullable ResourceLocation defaultName, Ingredient ingredient) {
        this.defaultName = defaultName;
        this.ingredient = ingredient;
    }

    public WildcardGristCostBuilder cost(long wildcardCost) {
        this.cost = wildcardCost;
        return this;
    }

    public WildcardGristCostBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public void build(RecipeOutput recipeOutput) {
        ResourceLocation name = Objects.requireNonNull(this.defaultName != null ? this.defaultName : BuiltInRegistries.ITEM.getKey((Object)this.ingredient.getItems()[0].getItem()));
        this.build(recipeOutput, name);
    }

    public void buildFor(RecipeOutput recipeOutput, String modId) {
        ResourceLocation name = Objects.requireNonNull(this.defaultName != null ? this.defaultName : BuiltInRegistries.ITEM.getKey((Object)this.ingredient.getItems()[0].getItem()));
        this.build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)modId, (String)name.getPath()));
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        if (this.cost == 0L) {
            throw new IllegalStateException("Must set the wildcard cost before building!");
        }
        recipeOutput.accept(id.withPrefix("grist_costs/"), (Recipe)new WildcardGristCost(this.ingredient, this.cost, Optional.ofNullable(this.priority)), null);
    }
}

