/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy.recipe.combination;

import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationInput;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
public interface CombinationRecipe
extends Recipe<CombinationInput> {
    public static final Supplier<RecipeType<CombinationRecipe>> RECIPE_TYPE = MSRecipeTypes.COMBINATION_TYPE;

    public static ItemStack findResult(CombinationInput combiner, Level level) {
        return level.getRecipeManager().getRecipeFor(RECIPE_TYPE.get(), (RecipeInput)combiner, level).map(recipe -> ((CombinationRecipe)recipe.value()).assemble(combiner, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    default public RecipeType<?> getType() {
        return RECIPE_TYPE.get();
    }

    default public List<JeiCombination> getJeiCombinations() {
        return Collections.emptyList();
    }
}

