/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.api.alchemy.recipe.combination;

import com.mraof.minestuck.alchemy.recipe.RegularCombinationRecipe;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CombinationRecipeBuilder {
    private final ItemStack output;
    private Ingredient input1;
    private Ingredient input2;
    private CombinationMode mode;
    private String suffix = "";

    private CombinationRecipeBuilder(ItemStack output) {
        this.output = Objects.requireNonNull(output);
    }

    public static CombinationRecipeBuilder of(ItemLike output) {
        return CombinationRecipeBuilder.of(new ItemStack((ItemLike)output.asItem()));
    }

    public static CombinationRecipeBuilder of(ItemStack output) {
        return new CombinationRecipeBuilder(output);
    }

    public CombinationRecipeBuilder input(TagKey<Item> tag) {
        return this.input(Ingredient.of(tag));
    }

    public CombinationRecipeBuilder input(ItemLike item) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public CombinationRecipeBuilder input(Ingredient ingredient) {
        if (this.input1 == null) {
            this.input1 = Objects.requireNonNull(ingredient);
        } else if (this.input2 == null) {
            this.input2 = Objects.requireNonNull(ingredient);
        } else {
            throw new IllegalStateException("Can't set more than two inputs");
        }
        return this;
    }

    public CombinationRecipeBuilder namedInput(TagKey<Item> tag) {
        this.input(Ingredient.of(tag));
        return this.namedSource(tag.location().getPath());
    }

    public CombinationRecipeBuilder namedInput(ItemLike item) {
        this.input(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this.namedSource(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath());
    }

    public CombinationRecipeBuilder namedSource(String str) {
        this.suffix = this.suffix.isEmpty() ? "_from_" + str : this.suffix + "_and_" + str;
        return this;
    }

    public CombinationRecipeBuilder and() {
        return this.mode(CombinationMode.AND);
    }

    public CombinationRecipeBuilder or() {
        return this.mode(CombinationMode.OR);
    }

    public CombinationRecipeBuilder mode(CombinationMode mode) {
        if (this.mode != null) {
            throw new IllegalStateException("Can't set mode twice");
        }
        this.mode = mode;
        return this;
    }

    public void build(RecipeOutput recipeOutput) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()));
        this.build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)(name.getPath() + this.suffix)));
    }

    public void buildFor(RecipeOutput recipeOutput, String modId) {
        ResourceLocation name = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()));
        this.build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(name.getPath() + this.suffix)));
    }

    public void build(RecipeOutput recipeOutput, ResourceLocation id) {
        recipeOutput.accept(id.withPrefix("combinations/"), (Recipe)new RegularCombinationRecipe(this.input1, this.input2, this.mode, this.output), null);
    }
}

