/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.CustomShapeBlock;
import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.EnumCassetteType;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.CassettePlayerBlockEntity;
import com.mraof.minestuck.item.CassetteItem;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class CassettePlayerBlock
extends CustomShapeBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<EnumCassetteType> CASSETTE = MSProperties.CASSETTE;

    public CassettePlayerBlock(BlockBehaviour.Properties properties, CustomVoxelShape shape) {
        super(properties, shape);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CASSETTE, (Comparable)((Object)EnumCassetteType.NONE)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            state = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, state, 2);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CassettePlayerBlockEntity) {
                CassettePlayerBlockEntity cassettePlayer = (CassettePlayerBlockEntity)blockEntity;
                if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    Item item = cassettePlayer.getCassette().getItem();
                    if (item instanceof CassetteItem) {
                        CassetteItem cassetteItem = (CassetteItem)item;
                        Registry jukeboxRegistry = level.registryAccess().registryOrThrow(Registries.JUKEBOX_SONG);
                        ResourceKey<JukeboxSong> cassetteSong = cassetteItem.cassetteType.getJukeboxSong();
                        if (cassetteSong != null) {
                            int songId = jukeboxRegistry.getId(cassetteSong);
                            level.levelEvent(1010, pos, songId);
                            player.awardStat(Stats.PLAY_RECORD);
                        }
                    }
                } else if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    level.levelEvent(1011, pos, 0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (state.getValue(CASSETTE) != EnumCassetteType.NONE && ((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            this.dropCassette(level, pos);
            state = (BlockState)state.setValue(CASSETTE, (Comparable)((Object)EnumCassetteType.NONE));
            level.setBlock(pos, state, 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void insertCassette(LevelAccessor level, BlockPos pos, BlockState state, ItemStack cassetteStack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CassettePlayerBlockEntity) {
            CassettePlayerBlockEntity cassettePlayer = (CassettePlayerBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && state.getValue(CASSETTE) == EnumCassetteType.NONE) {
                cassettePlayer.setCassette(cassetteStack.copy());
                Item item = cassetteStack.getItem();
                if (item instanceof CassetteItem) {
                    CassetteItem cassette = (CassetteItem)item;
                    level.setBlock(pos, (BlockState)state.setValue(CASSETTE, (Comparable)((Object)cassette.cassetteType)), 2);
                }
            }
        }
    }

    private void dropCassette(Level level, BlockPos pos) {
        CassettePlayerBlockEntity cassettePlayer;
        ItemStack itemstack;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CassettePlayerBlockEntity && !(itemstack = (cassettePlayer = (CassettePlayerBlockEntity)blockEntity).getCassette()).isEmpty()) {
            level.levelEvent(1011, pos, 0);
            cassettePlayer.clearContent();
            float f = 0.7f;
            double xOffset = (double)(f * level.random.nextFloat()) + 0.15;
            double yOffset = (double)(f * level.random.nextFloat()) + 0.66;
            double zOffset = (double)(f * level.random.nextFloat()) + 0.15;
            ItemStack itemstack1 = itemstack.copy();
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, itemstack1);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.dropCassette(level, pos);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CassettePlayerBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        CassettePlayerBlockEntity cassettePlayer;
        Item item;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CassettePlayerBlockEntity && (item = (cassettePlayer = (CassettePlayerBlockEntity)blockEntity).getCassette().getItem()) instanceof CassetteItem) {
            CassetteItem cassette = (CassetteItem)item;
            return cassette.getComparatorValue();
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CASSETTE});
        builder.add(new Property[]{OPEN});
    }
}

