/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CruxiteDowelBlock
extends Block
implements EntityBlock {
    public static final VoxelShape DOWEL_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    public static final EnumProperty<Type> DOWEL_TYPE = MSProperties.DOWEL_BLOCK;

    public CruxiteDowelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(DOWEL_TYPE, (Comparable)((Object)Type.DOWEL)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return DOWEL_SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        ItemStackBlockEntity be = new ItemStackBlockEntity(pos, state);
        be.setStack(new ItemStack((ItemLike)this));
        return be;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof ItemStackBlockEntity) {
            ItemStackBlockEntity stackEntity = (ItemStackBlockEntity)object;
            builder = builder.withDynamicDrop(ItemStackBlockEntity.ITEM_DYNAMIC, consumer -> consumer.accept(stackEntity.getStack()));
        }
        return super.getDrops(state, builder);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            CruxiteDowelBlock.dropDowel(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getClickedFace() == Direction.UP ? this.defaultBlockState() : null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStackBlockEntity stackEntity;
        ItemStack dowel;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemStackBlockEntity && !(dowel = (stackEntity = (ItemStackBlockEntity)blockEntity).getStack()).isEmpty()) {
            return dowel.copy();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public static void dropDowel(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemStackBlockEntity) {
            ItemStackBlockEntity stackEntity = (ItemStackBlockEntity)blockEntity;
            ItemStack stack = stackEntity.getStack();
            CruxiteDowelBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
        level.removeBlock(pos, false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DOWEL_TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        DOWEL,
        TOTEM;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

