/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public abstract class CustomCakeBlock
extends CakeBlock {
    protected CustomCakeBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            return this.eatCake(level, pos, state, player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        ItemStack itemstack = player.getItemInHand(InteractionHand.MAIN_HAND);
        return this.eatCake(level, pos, state, player) ? InteractionResult.SUCCESS : (itemstack.isEmpty() ? InteractionResult.CONSUME : InteractionResult.PASS);
    }

    public boolean eatCake(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return false;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        this.applyEffects(level, pos, state, player);
        int i = (Integer)state.getValue((Property)BITES);
        if (i < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        return true;
    }

    protected abstract void applyEffects(Level var1, BlockPos var2, BlockState var3, Player var4);
}

