/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public class CustomVoxelShape {
    public double[][] parts;

    public CustomVoxelShape(double[] ... parts) {
        this.parts = parts;
    }

    public CustomVoxelShape rotate(Direction dir) {
        double[][] out = (double[][])this.parts.clone();
        block7: for (int i = 0; i < out.length; ++i) {
            double[] part = out[i];
            switch (dir) {
                case WEST: {
                    out[i] = new double[]{part[2], part[1], 16.0 - part[3], part[5], part[4], 16.0 - part[0]};
                    continue block7;
                }
                case SOUTH: {
                    out[i] = new double[]{16.0 - part[3], part[1], 16.0 - part[5], 16.0 - part[0], part[4], 16.0 - part[2]};
                    continue block7;
                }
                case EAST: {
                    out[i] = new double[]{16.0 - part[5], part[1], part[0], 16.0 - part[2], part[4], part[3]};
                    continue block7;
                }
                case UP: {
                    out[i] = new double[]{part[0], part[2], part[4], part[3], part[5], part[1]};
                    continue block7;
                }
                case DOWN: {
                    out[i] = new double[]{part[0], part[2], 16.0 - part[4], part[3], part[5], 16.0 - part[1]};
                }
            }
        }
        return new CustomVoxelShape(out);
    }

    public CustomVoxelShape translate(double x, double y, double z) {
        double[][] out = (double[][])this.parts.clone();
        for (int i = 0; i < out.length; ++i) {
            double[] dArray = out[i];
            dArray[0] = dArray[0] + x;
            double[] dArray2 = out[i];
            dArray2[1] = dArray2[1] + y;
            double[] dArray3 = out[i];
            dArray3[2] = dArray3[2] + z;
            double[] dArray4 = out[i];
            dArray4[3] = dArray4[3] + x;
            double[] dArray5 = out[i];
            dArray5[4] = dArray5[4] + y;
            double[] dArray6 = out[i];
            dArray6[5] = dArray6[5] + z;
        }
        return new CustomVoxelShape(out);
    }

    public CustomVoxelShape merge(CustomVoxelShape ... shapes) {
        double[][] parts = (double[][])this.parts.clone();
        for (CustomVoxelShape shape : shapes) {
            parts = (double[][])ArrayUtils.addAll((Object[])parts, (Object[])shape.parts);
        }
        return new CustomVoxelShape(parts);
    }

    public VoxelShape create(Direction dir) {
        CustomVoxelShape shape = this.rotate(dir);
        VoxelShape out = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (double[] part : shape.parts) {
            out = Shapes.or((VoxelShape)out, (VoxelShape)Block.box((double)Math.min(part[0], part[3]), (double)Math.min(part[1], part[4]), (double)Math.min(part[2], part[5]), (double)Math.max(part[0], part[3]), (double)Math.max(part[1], part[4]), (double)Math.max(part[2], part[5])));
        }
        return out;
    }

    public Map<Direction, VoxelShape> createRotatedShapes() {
        return Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)this.create(Direction.NORTH), (Object)Direction.SOUTH, (Object)this.create(Direction.SOUTH), (Object)Direction.WEST, (Object)this.create(Direction.WEST), (Object)Direction.EAST, (Object)this.create(Direction.EAST)));
    }

    public ImmutableMap<Direction, VoxelShape> createRotatedShapesAllDirections() {
        return ImmutableMap.builder().put((Object)Direction.UP, (Object)this.create(Direction.UP)).put((Object)Direction.DOWN, (Object)this.create(Direction.DOWN)).put((Object)Direction.NORTH, (Object)this.create(Direction.NORTH)).put((Object)Direction.SOUTH, (Object)this.create(Direction.SOUTH)).put((Object)Direction.WEST, (Object)this.create(Direction.WEST)).put((Object)Direction.EAST, (Object)this.create(Direction.EAST)).build();
    }

    public double getMaxY() {
        double result = 0.0;
        for (double[] part : this.parts) {
            result = Math.max(result, Math.max(part[1], part[4]));
        }
        return result / 16.0;
    }
}

