/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.util.MSSoundEvents;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.level.Level;

public enum EnumCassetteType implements StringRepresentable
{
    NONE(null, null),
    FIVE((ResourceKey<JukeboxSong>)JukeboxSongs.FIVE, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.DARKNESS, 500, 0), 0.9f)),
    OTHERSIDE((ResourceKey<JukeboxSong>)JukeboxSongs.OTHERSIDE, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1, false, false, false))),
    ELEVEN((ResourceKey<JukeboxSong>)JukeboxSongs.ELEVEN, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.WITHER, 160, 0), 0.1f)),
    THIRTEEN((ResourceKey<JukeboxSong>)JukeboxSongs.THIRTEEN, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.HUNGER, 500, 0), 0.3f)),
    BLOCKS((ResourceKey<JukeboxSong>)JukeboxSongs.BLOCKS, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.BLINDNESS, 100, 0), 0.15f)),
    CAT((ResourceKey<JukeboxSong>)JukeboxSongs.CAT, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 200, 0, false, false, false))),
    CHIRP((ResourceKey<JukeboxSong>)JukeboxSongs.CHIRP, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.SLOW_FALLING, 100, 0, false, false, false))),
    DANCE_STAB_DANCE(MSSoundEvents.JUKEBOX_SONG_DANCE_STAB_DANCE, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 600, 3), 0.3f)),
    EMISSARY_OF_DANCE(MSSoundEvents.JUKEBOX_SONG_EMISSARY_OF_DANCE, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.POISON, 200, 0), 0.1f)),
    FAR((ResourceKey<JukeboxSong>)JukeboxSongs.FAR, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 0, false, false, false))),
    MALL((ResourceKey<JukeboxSong>)JukeboxSongs.MALL, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.WATER_BREATHING, 100, 0, false, false, false))),
    MELLOHI((ResourceKey<JukeboxSong>)JukeboxSongs.MELLOHI, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.LEVITATION, 60, 0), 0.2f)),
    PIGSTEP((ResourceKey<JukeboxSong>)JukeboxSongs.PIGSTEP, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, 0, false, false, false))),
    RETRO_BATTLE_THEME(MSSoundEvents.JUKEBOX_SONG_RETRO_BATTLE_THEME, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 100, 2, false, false, false))),
    STAL((ResourceKey<JukeboxSong>)JukeboxSongs.STAL, EnumCassetteType.userEffect(() -> new MobEffectInstance(MobEffects.JUMP, 100, 1, false, false, false))),
    STRAD((ResourceKey<JukeboxSong>)JukeboxSongs.STRAD, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.UNLUCK, 200, 0), 0.1f)),
    WAIT((ResourceKey<JukeboxSong>)JukeboxSongs.WAIT, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0), 0.3f)),
    WARD((ResourceKey<JukeboxSong>)JukeboxSongs.WARD, EnumCassetteType.onHitEffect(() -> new MobEffectInstance(MobEffects.GLOWING, 750, 0), 1.0f));

    @Nullable
    private final ResourceKey<JukeboxSong> jukeboxSong;
    @Nullable
    private final EffectContainer effectContainer;

    private EnumCassetteType(ResourceKey<JukeboxSong> jukeboxSong, EffectContainer effectContainer) {
        this.jukeboxSong = jukeboxSong;
        this.effectContainer = effectContainer;
    }

    @Nonnull
    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    @Nullable
    public ResourceKey<JukeboxSong> getJukeboxSong() {
        return this.jukeboxSong;
    }

    @Nullable
    public Holder<SoundEvent> getSoundEvent(Level level) {
        Registry jukeboxRegistry = level.registryAccess().registryOrThrow(Registries.JUKEBOX_SONG);
        if (this.jukeboxSong == null) {
            return null;
        }
        JukeboxSong jukeboxSongObject = (JukeboxSong)jukeboxRegistry.get(this.jukeboxSong);
        if (jukeboxSongObject == null) {
            return null;
        }
        return jukeboxSongObject.soundEvent();
    }

    @Nonnull
    public EffectContainer getEffectContainer() {
        return Objects.requireNonNull(this.effectContainer);
    }

    private static EffectContainer userEffect(Supplier<MobEffectInstance> effect) {
        return new EffectContainer(effect, 1.0f, false);
    }

    private static EffectContainer onHitEffect(Supplier<MobEffectInstance> effect, float chance) {
        return new EffectContainer(effect, chance, true);
    }

    public record EffectContainer(Supplier<MobEffectInstance> effect, float applyingChance, boolean onHit) {
    }
}

