/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FragileBlock
extends Block {
    private static final VoxelShape COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public FragileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    protected void entityInside(BlockState stateIn, Level level, BlockPos pos, Entity entityIn) {
        this.attemptBreak(level, entityIn, pos);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        super.fallOn(level, state, pos, entityIn, fallDistance);
        this.attemptBreak(level, entityIn, pos);
    }

    public void attemptBreak(Level level, Entity entityIn, BlockPos pos) {
        if (entityIn instanceof Player) {
            Player steppingPlayer = (Player)entityIn;
            if (!level.isClientSide) {
                AABB obfuscateBB = new AABB(pos);
                if (this.directionNeedsObfuscation(level, pos.east())) {
                    obfuscateBB = obfuscateBB.contract(0.6, 0.0, 0.0);
                }
                if (this.directionNeedsObfuscation(level, pos.west())) {
                    obfuscateBB = obfuscateBB.contract(-0.6, 0.0, 0.0);
                }
                if (this.directionNeedsObfuscation(level, pos.south())) {
                    obfuscateBB = obfuscateBB.contract(0.0, 0.0, 0.6);
                }
                if (this.directionNeedsObfuscation(level, pos.north())) {
                    obfuscateBB = obfuscateBB.contract(0.0, 0.0, -0.6);
                }
                if (steppingPlayer.getBoundingBox().intersects(obfuscateBB) && !FragileBlock.isSecure(level.getBlockState(pos.below()))) {
                    entityIn.makeStuckInBlock(level.getBlockState(pos), new Vec3((double)0.9f, 0.2, (double)0.9f));
                    level.destroyBlock(pos, false);
                }
            }
        }
    }

    public boolean directionNeedsObfuscation(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.is((Block)this) ? FragileBlock.isSecure(level.getBlockState(pos.below())) : FragileBlock.isSecure(state);
    }

    public static boolean isSecure(BlockState state) {
        return !state.isAir() && !state.is(BlockTags.FIRE) && !state.liquid() && !state.canBeReplaced();
    }
}

