/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.AbstractGateBlock;
import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.GateBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.OnCollisionTeleporterBlockEntity;
import com.mraof.minestuck.world.GateHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GateBlock
extends AbstractGateBlock {
    private static final Logger LOGGER = LogManager.getLogger();

    public GateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected final boolean isValid(BlockPos mainPos, Level level) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockState block;
                if (x == 0 && z == 0 || (block = level.getBlockState(mainPos.offset(x, 0, z))).is((Block)MSBlocks.GATE.get())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected BlockPos findMainComponent(BlockPos pos, Level level) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockState block;
                if (x == 0 && z == 0 || !(block = level.getBlockState(pos.offset(x, 0, z))).is((Block)MSBlocks.GATE_MAIN.get())) continue;
                return pos.offset(x, 0, z);
            }
        }
        return null;
    }

    @Override
    protected final void removePortal(BlockPos mainPos, Level level) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (!level.getBlockState(mainPos.offset(x, 0, z)).is((Block)this)) continue;
                level.removeBlock(mainPos.offset(x, 0, z), false);
            }
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        if (((Boolean)MinestuckConfig.SERVER.canBreakGates.get()).booleanValue()) {
            return super.getExplosionResistance(state, level, pos, explosion);
        }
        return 3600000.0f;
    }

    public static void placeGate(CommonLevelAccessor level, BlockPos centerPos, GateHandler.Type type, int blockFlag) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                if (offsetX == 0 && offsetZ == 0) {
                    level.setBlock(centerPos, ((Block)MSBlocks.GATE_MAIN.get()).defaultBlockState(), blockFlag);
                    BlockEntity blockEntity = level.getBlockEntity(centerPos);
                    if (blockEntity instanceof GateBlockEntity) {
                        GateBlockEntity gate = (GateBlockEntity)blockEntity;
                        gate.gateType = type;
                        continue;
                    }
                    LOGGER.error("Expected a gate block entity after placing a gate block, but got {}!", (Object)blockEntity);
                    continue;
                }
                level.setBlock(centerPos.offset(offsetX, 0, offsetZ), ((Block)MSBlocks.GATE.get()).defaultBlockState(), blockFlag);
            }
        }
    }

    public static class Main
    extends GateBlock
    implements EntityBlock {
        public Main(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new GateBlockEntity(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
            return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.GATE.get(), OnCollisionTeleporterBlockEntity::serverTick) : null;
        }

        @Override
        @Nullable
        protected BlockPos findMainComponent(BlockPos pos, Level level) {
            return pos;
        }

        protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
            if (entityIn instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityIn;
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof GateBlockEntity) {
                    GateBlockEntity gate = (GateBlockEntity)blockEntity;
                    gate.onCollision(player);
                }
            }
        }
    }
}

