/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class GlowystoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public GlowystoneWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)RedstoneSide.NONE)).setValue(EAST, (Comparable)RedstoneSide.NONE)).setValue(SOUTH, (Comparable)RedstoneSide.NONE)).setValue(WEST, (Comparable)RedstoneSide.NONE));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[GlowystoneWireBlock.getAABBIndex(state)];
    }

    private static int getAABBIndex(BlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.getValue(NORTH) != RedstoneSide.NONE;
        boolean flag1 = state.getValue(EAST) != RedstoneSide.NONE;
        boolean flag2 = state.getValue(SOUTH) != RedstoneSide.NONE;
        boolean bl = flag3 = state.getValue(WEST) != RedstoneSide.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << Direction.NORTH.get2DDataValue();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << Direction.EAST.get2DDataValue();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << Direction.SOUTH.get2DDataValue();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << Direction.WEST.get2DDataValue();
        }
        return i;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(WEST, (Comparable)this.getSide((LevelReader)level, blockpos, Direction.WEST))).setValue(EAST, (Comparable)this.getSide((LevelReader)level, blockpos, Direction.EAST))).setValue(NORTH, (Comparable)this.getSide((LevelReader)level, blockpos, Direction.NORTH))).setValue(SOUTH, (Comparable)this.getSide((LevelReader)level, blockpos, Direction.SOUTH));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue(WEST, (Comparable)this.getSide((LevelReader)level, currentPos, Direction.WEST))).setValue(EAST, (Comparable)this.getSide((LevelReader)level, currentPos, Direction.EAST))).setValue(NORTH, (Comparable)this.getSide((LevelReader)level, currentPos, Direction.NORTH))).setValue(SOUTH, (Comparable)this.getSide((LevelReader)level, currentPos, Direction.SOUTH)) : (BlockState)stateIn.setValue((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((LevelReader)level, currentPos, facing));
    }

    private RedstoneSide getSide(LevelReader level, BlockPos pos, Direction face) {
        boolean flag;
        BlockPos blockpos = pos.relative(face);
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockpos1 = pos.above();
        BlockState blockstate1 = level.getBlockState(blockpos1);
        if (!blockstate1.isRedstoneConductor((BlockGetter)level, blockpos1) && (flag = Block.canSupportCenter((LevelReader)level, (BlockPos)blockpos, (Direction)Direction.UP)) && this.canConnectTo(level.getBlockState(blockpos.above()))) {
            if (GlowystoneWireBlock.isShapeFullBlock((VoxelShape)blockstate.getBlockSupportShape((BlockGetter)level, blockpos))) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !this.canConnectTo(level.getBlockState(blockpos)) && (blockstate.isRedstoneConductor((BlockGetter)level, blockpos) || !this.canConnectTo(level.getBlockState(blockpos.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return Block.canSupportCenter((LevelReader)level, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    private BlockState updateSurroundingGlowystone(Level level, BlockPos pos, BlockState state) {
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            level.updateNeighborsAt(blockpos, (Block)this);
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(Level level, BlockPos pos) {
        if (level.getBlockState(pos).is((Block)this)) {
            level.updateNeighborsAt(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide) {
            this.updateSurroundingGlowystone(level, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                level.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(level, pos.relative(direction));
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.relative(direction);
                if (level.getBlockState(blockpos).isRedstoneConductor((BlockGetter)level, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(level, blockpos.above());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(level, blockpos.below());
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!level.isClientSide) {
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            this.updateSurroundingGlowystone(level, pos, state);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(level, pos.relative(direction));
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.relative(direction);
                if (level.getBlockState(blockpos).isRedstoneConductor((BlockGetter)level, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(level, blockpos.above());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(level, blockpos.below());
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            if (this.canSurvive(state, (LevelReader)level, pos)) {
                this.updateSurroundingGlowystone(level, pos, state);
            } else {
                GlowystoneWireBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                level.removeBlock(pos, false);
            }
        }
    }

    protected boolean canConnectTo(BlockState blockState) {
        return blockState.is((Block)this);
    }

    public static int colorMultiplier() {
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 0.2f;
        float f3 = 0.0f;
        int i = Mth.clamp((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = Mth.clamp((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = Mth.clamp((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double y = (double)pos.getY() + 0.0625;
        double z = (double)pos.getZ() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.8f, 0.0f), 1.0f), x, y, z, 0.0, 0.0, 0.0);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(NORTH)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(EAST)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(EAST, (Comparable)((RedstoneSide)state.getValue(NORTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(EAST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(SOUTH)));
            }
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((RedstoneSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((RedstoneSide)state.getValue(NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, (Comparable)((RedstoneSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((RedstoneSide)state.getValue(EAST)));
            }
        }
        return super.mirror(state, mirrorIn);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

