/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.blockentity.HorseClockBlockEntity;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HorseClockBlock
extends MachineBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public HorseClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        HorseClockBlock.updateSurvival(state, level, pos);
    }

    public static void updateSurvival(BlockState state, Level level, BlockPos pos) {
        if (state.is((Block)MSBlocks.HORSE_CLOCK.BOTTOM.get()) && !level.getBlockState(pos.above()).is((Block)MSBlocks.HORSE_CLOCK.CENTER.get())) {
            level.destroyBlock(pos, true);
        } else if (!(!state.is((Block)MSBlocks.HORSE_CLOCK.CENTER.get()) || level.getBlockState(pos.above()).is((Block)MSBlocks.HORSE_CLOCK.TOP.get()) && level.getBlockState(pos.below()).is((Block)MSBlocks.HORSE_CLOCK.BOTTOM.get()))) {
            level.destroyBlock(pos, true);
        } else if (state.is((Block)MSBlocks.HORSE_CLOCK.TOP.get()) && !level.getBlockState(pos.below()).is((Block)MSBlocks.HORSE_CLOCK.CENTER.get())) {
            level.destroyBlock(pos, true);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.tick(state, level, pos, rand);
        if ((Integer)state.getValue((Property)POWER) > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(0)), 11);
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return (Integer)state.getValue((Property)POWER) > 0;
    }

    protected int getSignal(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)POWER);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
    }

    public static class Bottom
    extends HorseClockBlock
    implements EntityBlock {
        public Bottom(MachineMultiblock machine, BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof HorseClockBlockEntity) {
                HorseClockBlockEntity be = (HorseClockBlockEntity)blockEntity;
                HorseClockBlockEntity.fullPower(level, be);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new HorseClockBlockEntity(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
            return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.HORSE_CLOCK.get(), HorseClockBlockEntity::serverTick) : null;
        }
    }
}

