/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItems;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

@MethodsReturnNonnullByDefault
public record ItemBlockPair<B extends Block, I extends Item>(DeferredBlock<B> blockHolder, DeferredItem<I> itemHolder) implements ItemLike
{
    public B asBlock() {
        return (B)((Block)this.blockHolder.get());
    }

    public I asItem() {
        return (I)((Item)this.itemHolder.get());
    }

    public static <B extends Block> ItemBlockPair<B, BlockItem> register(String name, Supplier<B> blockSupplier) {
        return ItemBlockPair.register(name, blockSupplier, Item.Properties::new);
    }

    public static <B extends Block> ItemBlockPair<B, BlockItem> register(String name, Supplier<B> blockSupplier, Supplier<Item.Properties> properties) {
        return ItemBlockPair.register(name, blockSupplier, (B block) -> new BlockItem(block, (Item.Properties)properties.get()));
    }

    public static <B extends Block, I extends Item> ItemBlockPair<B, I> register(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        DeferredBlock blockHolder = MSBlocks.REGISTER.register(name, blockSupplier);
        DeferredItem itemHolder = MSItems.REGISTER.register(name, () -> (Item)itemSupplier.apply((Block)blockHolder.get()));
        return new ItemBlockPair<B, I>(blockHolder, itemHolder);
    }
}

