/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.entity.LotusFlowerEntity;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LotusTimeCapsuleBlock
extends MachineBlock {
    protected final Map<Direction, VoxelShape> shape;

    public LotusTimeCapsuleBlock(CustomVoxelShape shape, BlockBehaviour.Properties properties) {
        super(properties);
        this.shape = shape.createRotatedShapes();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (mirror != Mirror.NONE) {
            boolean clockwise = mirror == Mirror.LEFT_RIGHT ^ direction.getAxis() == Direction.Axis.X;
            if (clockwise) {
                return (BlockState)state.setValue((Property)FACING, (Comparable)direction.getClockWise());
            }
            return (BlockState)state.setValue((Property)FACING, (Comparable)direction.getCounterClockWise());
        }
        return state;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        pLevel.getEntitiesOfClass(LotusFlowerEntity.class, new AABB(pPos.above())).forEach(Entity::discard);
    }
}

