/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.LotusTimeCapsuleBlock;
import com.mraof.minestuck.block.MSBlockShapes;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.entity.LotusFlowerEntity;
import com.mraof.minestuck.entity.MSEntityTypes;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class LotusTimeCapsuleMultiblock
extends MachineMultiblock {
    public final DeferredBlock<Block> CORNER = this.register("lotus_time_capsule_base", () -> new LotusTimeCapsuleBlock(MSBlockShapes.LOTUS_TIME_CAPSULE, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(-1.0f).noLootTable()));

    public LotusTimeCapsuleMultiblock(DeferredRegister.Blocks register) {
        super(register);
        this.addDirectionPlacement(0, 0, 0, (Supplier<Block>)this.CORNER, Direction.WEST);
        this.addDirectionPlacement(1, 0, 0, (Supplier<Block>)this.CORNER, Direction.NORTH);
        this.addDirectionPlacement(0, 0, 1, (Supplier<Block>)this.CORNER, Direction.SOUTH);
        this.addDirectionPlacement(1, 0, 1, (Supplier<Block>)this.CORNER, Direction.EAST);
    }

    @Override
    public void placeAdditional(Level level, MachineMultiblock.Placement placement) {
        super.placeAdditional(level, placement);
        LotusFlowerEntity lotusFlowerEntity = (LotusFlowerEntity)MSEntityTypes.LOTUS_FLOWER.get().create(level);
        BlockPos offset = new BlockPos(1, 0, 1).rotate(placement.rotation());
        lotusFlowerEntity.moveTo(placement.zeroPos().getX() + Math.max(0, offset.getX()), (double)placement.zeroPos().getY() + MSBlockShapes.LOTUS_TIME_CAPSULE.getMaxY(), placement.zeroPos().getZ() + Math.max(0, offset.getZ()), 0.0f, 0.0f);
        level.addFreshEntity((Entity)lotusFlowerEntity);
    }
}

