/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.util.MSTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class PushableBlock
extends FallingBlock {
    public final Maneuverability maneuverability;

    protected PushableBlock(BlockBehaviour.Properties properties, Maneuverability maneuverability) {
        super(properties);
        this.maneuverability = maneuverability;
    }

    protected MapCodec<PushableBlock> codec() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Direction direction;
        boolean willPush = !player.isShiftKeyDown() && this.maneuverability == Maneuverability.PUSH_AND_PULL || this.maneuverability == Maneuverability.PUSH || (!player.isShiftKeyDown() || this.maneuverability != Maneuverability.PUSH_AND_PULL) && this.maneuverability != Maneuverability.PULL;
        Direction direction2 = direction = willPush ? hit.getDirection().getOpposite() : hit.getDirection();
        if ((direction.getAxis() == Direction.Axis.X || direction.getAxis() == Direction.Axis.Z) && PushableBlock.isReplaceable(level.getBlockState(pos.relative(direction)))) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 0.6f, 1.3f);
                level.removeBlock(pos, false);
                level.destroyBlock(pos.relative(direction), true);
                level.setBlock(pos.relative(direction), state, 3);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected int getDelayAfterPlace() {
        return 0;
    }

    public void onLand(Level level, BlockPos pos, BlockState fallingBlockState, BlockState replacedState, FallingBlockEntity fallingBlockEntity) {
        level.playSound(null, pos, SoundEvents.GILDED_BLACKSTONE_STEP, SoundSource.BLOCKS, 0.5f, 0.3f);
    }

    public static boolean isReplaceable(BlockState state) {
        return PushableBlock.isFree((BlockState)state) || state.is(MSTags.Blocks.PUSHABLE_BLOCK_REPLACEABLE);
    }

    public static enum Maneuverability {
        PUSH,
        PULL,
        PUSH_AND_PULL;

    }
}

