/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class SpecialButtonBlock
extends ButtonBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public final boolean explosive;

    public SpecialButtonBlock(boolean explosive, BlockSetType type, int ticksToStayPressed, BlockBehaviour.Properties properties) {
        super(type, ticksToStayPressed, properties);
        this.explosive = explosive;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean b = (Boolean)state.getValue((Property)POWERED);
        super.tick(state, level, pos, random);
        if (level.getBlockState(pos).getBlock() != this) {
            LOGGER.warn("Tick update without the correct block/position?");
            return;
        }
        boolean b1 = (Boolean)level.getBlockState(pos).getValue((Property)POWERED);
        if (this.explosive && b && !b1) {
            level.removeBlock(pos, false);
            level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.5f, Level.ExplosionInteraction.BLOCK);
        }
    }
}

