/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SpecialTNTBlock
extends TntBlock {
    private final boolean primed;
    private final boolean unstable;
    private final boolean instant;

    public SpecialTNTBlock(BlockBehaviour.Properties builder, boolean primed, boolean unstable, boolean instant) {
        super(builder);
        this.primed = primed;
        this.unstable = unstable;
        this.instant = instant;
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (this.primed) {
            this.explode(level, pos, (LivingEntity)player);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        }
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
        this.explode(level, pos, igniter);
    }

    private void explode(Level level, BlockPos pos, LivingEntity igniter) {
        if (!level.isClientSide) {
            PrimedTnt entity = new PrimedTnt(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, igniter);
            if (this.instant) {
                entity.setFuse(0);
            }
            level.addFreshEntity((Entity)entity);
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosionIn) {
        if (!level.isClientSide) {
            PrimedTnt entity = new PrimedTnt(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, explosionIn.getIndirectSourceEntity());
            entity.setFuse(level.random.nextInt(entity.getFuse() / 4) + entity.getFuse() / 8);
            if (this.instant) {
                entity.setFuse(entity.getFuse() / 2);
            }
            level.addFreshEntity((Entity)entity);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.unstable && random.nextDouble() < 0.1) {
            this.explode((Level)level, pos, null);
            level.removeBlock(pos, false);
        }
    }
}

