/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.CustomShapeBlock;
import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.util.MSDamageSources;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class SpikeBlock
extends CustomShapeBlock {
    public SpikeBlock(BlockBehaviour.Properties properties, CustomVoxelShape shape) {
        super(properties, shape);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.causeFallDamage(fallDistance, 3.0f, level.damageSources().fall());
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.fallDistance < 1.0f && !level.isClientSide && (entityIn.xOld != entityIn.getX() || entityIn.zOld != entityIn.getZ())) {
            double distanceX = Math.abs(entityIn.getX() - entityIn.xOld);
            double distanceZ = Math.abs(entityIn.getZ() - entityIn.zOld);
            entityIn.makeStuckInBlock(state, new Vec3((double)0.3f, 0.9, (double)0.3f));
            if (distanceX >= 0.003 || distanceZ >= 0.003) {
                entityIn.hurt(MSDamageSources.spike(level.registryAccess()), 1.0f);
            }
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }
}

