/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.CustomShapeBlock;
import com.mraof.minestuck.block.MSBlockShapes;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.blockentity.ItemStackBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.item.components.StoneTabletTextComponent;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StoneTabletBlock
extends CustomShapeBlock
implements EntityBlock {
    public static final BooleanProperty CARVED = MSProperties.CARVED;

    public StoneTabletBlock(BlockBehaviour.Properties properties) {
        super(properties, MSBlockShapes.STONE_TABLET);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CARVED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        ItemStackBlockEntity be = new ItemStackBlockEntity(pos, state);
        be.setStack(new ItemStack((ItemLike)this));
        return be;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof ItemStackBlockEntity) {
            ItemStackBlockEntity itemBE = (ItemStackBlockEntity)object;
            builder = builder.withDynamicDrop(ItemStackBlockEntity.ITEM_DYNAMIC, consumer -> consumer.accept(itemBE.getStack()));
        }
        return super.getDrops(state, builder);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ItemStackBlockEntity) {
                ItemStackBlockEntity itemStackBE = (ItemStackBlockEntity)blockEntity;
                String text = StoneTabletTextComponent.getText(itemStackBE.getStack());
                MSScreenFactories.displayStoneTabletScreen(player, InteractionHand.MAIN_HAND, text, false);
            }
        } else if (!level.isClientSide) {
            StoneTabletBlock.dropTablet(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getClickedFace() == Direction.UP ? super.getStateForPlacement(context) : null;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStackBlockEntity blockEntity;
        ItemStack tabletItemStack;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ItemStackBlockEntity && !(tabletItemStack = (blockEntity = (ItemStackBlockEntity)blockEntity2).getStack()).isEmpty()) {
            return tabletItemStack.copy();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public static void dropTablet(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemStackBlockEntity) {
            ItemStackBlockEntity blockEntity2 = (ItemStackBlockEntity)blockEntity;
            ItemStack stack = blockEntity2.getStack();
            StoneTabletBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
        level.removeBlock(pos, false);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CARVED});
    }
}

