/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block;

import com.mraof.minestuck.block.MSDirectionalBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;

public class TrajectoryBlock
extends MSDirectionalBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int UPWARDS_POWER_MIN = 7;

    protected TrajectoryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockState trajectoryState = level.getBlockState(pos);
        if (trajectoryState.getValue((Property)FACING) == Direction.UP && (Integer)trajectoryState.getValue((Property)POWER) >= 7) {
            entityIn.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        } else {
            super.fallOn(level, state, pos, entityIn, fallDistance);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entityIn) {
        super.stepOn(level, pos, state, entityIn);
        BlockState blockState = level.getBlockState(pos);
        this.updatePower(level, pos);
        int power = (Integer)blockState.getValue((Property)POWER);
        double powerMod = (double)power / 16.0;
        if (!(power == 0 || blockState.getValue((Property)FACING) == Direction.UP && power < 7 || entityIn.isShiftKeyDown())) {
            if (entityIn.onGround()) {
                entityIn.setOnGround(false);
            }
            entityIn.setDeltaMovement(entityIn.getDeltaMovement().x * 0.8 + (double)((Direction)blockState.getValue((Property)FACING)).getStepX() * powerMod, entityIn.getDeltaMovement().y * 0.8 + (double)((Direction)blockState.getValue((Property)FACING)).getStepY() * powerMod, entityIn.getDeltaMovement().z * 0.8 + (double)((Direction)blockState.getValue((Property)FACING)).getStepZ() * powerMod);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        int newPower;
        BlockState newState;
        BlockState oldState;
        if (!level.isClientSide && (oldState = level.getBlockState(pos)) != (newState = TrajectoryBlock.setPower(oldState, newPower = level.getBestNeighborSignal(pos)))) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public static BlockState setPower(BlockState state, int newPower) {
        return (BlockState)((BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPower > 0));
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if ((Integer)stateIn.getValue((Property)POWER) != 0 && rand.nextInt(10 - ((Integer)stateIn.getValue((Property)POWER) + 1) / 4) == 0) {
            double powerMod = (double)((Integer)stateIn.getValue((Property)POWER)).intValue() / 120.0 + 0.075;
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() + 0.5, (double)pos.above().getY() + 0.25, (double)pos.getZ() + 0.5, (double)((Direction)stateIn.getValue((Property)FACING)).getStepX() * powerMod, (double)((Direction)stateIn.getValue((Property)FACING)).getStepY() * powerMod, (double)((Direction)stateIn.getValue((Property)FACING)).getStepZ() * powerMod);
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        if ((Integer)state.getValue((Property)POWER) >= 7 && state.getValue((Property)FACING) == Direction.UP || (Integer)state.getValue((Property)POWER) > 0 && state.getValue((Property)FACING) != Direction.UP) {
            return PathType.DANGER_OTHER;
        }
        return PathType.WALKABLE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{POWERED});
    }
}

