/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.fluid;

import com.mraof.minestuck.fluid.MSFluidType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public class MSLiquidBlock
extends LiquidBlock {
    protected final boolean underwaterParticles;

    public MSLiquidBlock(FlowingFluid fluid, boolean underwaterParticles, BlockBehaviour.Properties properties) {
        super(fluid, properties);
        this.underwaterParticles = underwaterParticles;
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource rand) {
        super.animateTick(state, level, blockPos, rand);
        this.ambientSounds(state, level, blockPos, rand);
        if (this.underwaterParticles && rand.nextInt(20) == 0 && state.getFluidState().isSource()) {
            level.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)blockPos.getX() + rand.nextDouble(), (double)blockPos.getY() + rand.nextDouble(), (double)blockPos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void ambientSounds(BlockState state, Level level, BlockPos blockPos, RandomSource rand) {
        FlowingFluid fluid;
        FluidType fluidType;
        if (rand.nextInt(96) == 0 && (fluidType = (fluid = this.fluid).getFluidType()) instanceof MSFluidType) {
            MSFluidType fluidType2 = (MSFluidType)fluidType;
            MSFluidType.Style fluidStyle = fluidType2.getFluidStyle();
            if (!state.getFluidState().isSource()) {
                level.playLocalSound((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, fluidStyle.ambientSound(), SoundSource.BLOCKS, rand.nextFloat() * 0.4f, fluidStyle.soundPitch() + (rand.nextFloat() - 0.9f), false);
            }
        }
    }
}

