/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.EnumDowelType;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.machine.AlchemiterMultiblock;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.blockentity.machine.AlchemiterBlockEntity;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AlchemiterBlock
extends MachineBlock
implements EditmodeDestroyable {
    protected final Map<Direction, VoxelShape> shape;
    protected final boolean recursive;
    protected final boolean corner;
    protected final BlockPos mainPos;
    protected final AlchemiterMultiblock multiblock;

    public AlchemiterBlock(AlchemiterMultiblock multiblock, CustomVoxelShape shape, boolean recursive, boolean corner, BlockPos mainPos, BlockBehaviour.Properties properties) {
        super(properties);
        this.multiblock = multiblock;
        this.shape = shape.createRotatedShapes();
        this.recursive = recursive;
        this.corner = corner;
        this.mainPos = mainPos;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        Optional<BlockPos> mainPos = this.getMainPos(state, pos, (BlockGetter)level);
        if (mainPos.isPresent() && (blockEntity = level.getBlockEntity(mainPos.get())) instanceof AlchemiterBlockEntity) {
            AlchemiterBlockEntity alchemiter = (AlchemiterBlockEntity)blockEntity;
            alchemiter.onRightClick(level, player, state, hit.getDirection());
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.getMainPos(state, pos, (BlockGetter)level).ifPresent(mainPos -> {
                BlockEntity patt0$temp = level.getBlockEntity(mainPos);
                if (patt0$temp instanceof AlchemiterBlockEntity) {
                    AlchemiterBlockEntity alchemiter = (AlchemiterBlockEntity)patt0$temp;
                    alchemiter.breakMachine();
                    if (mainPos.equals((Object)pos)) {
                        alchemiter.dropItem(null);
                    }
                }
            });
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public void destroyFull(BlockState state, Level level, BlockPos pos) {
        Optional placement = this.getMainPos(state, pos, (BlockGetter)level).flatMap(mainPos -> this.multiblock.findPlacementFromPad((LevelAccessor)level, (BlockPos)mainPos));
        if (placement.isPresent()) {
            this.multiblock.removeAt((LevelAccessor)level, (MachineMultiblock.Placement)placement.get());
        } else {
            for (MachineMultiblock.Placement placementGuess : this.multiblock.guessPlacement(pos, state)) {
                this.multiblock.removeAt((LevelAccessor)level, placementGuess);
            }
        }
    }

    public Optional<BlockPos> getMainPos(BlockState state, BlockPos pos, BlockGetter level) {
        return this.getMainPos(state, pos, level, 4);
    }

    protected Optional<BlockPos> getMainPos(BlockState state, BlockPos pos, BlockGetter level, int count) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos newPos = pos.offset((Vec3i)this.mainPos.rotate(MSRotationUtil.fromDirection(direction)));
        if (!this.recursive) {
            return Optional.of(newPos);
        }
        BlockState newState = level.getBlockState(newPos);
        if (count > 0 && newState.getBlock() instanceof AlchemiterBlock && ((AlchemiterBlock)newState.getBlock()).corner && ((Direction)newState.getValue((Property)FACING)).equals(this.corner ? ((Direction)state.getValue((Property)FACING)).getClockWise() : state.getValue((Property)FACING))) {
            return ((AlchemiterBlock)newState.getBlock()).getMainPos(newState, newPos, level, count - 1);
        }
        return Optional.empty();
    }

    public static class Pad
    extends AlchemiterBlock
    implements EntityBlock {
        public static final EnumProperty<EnumDowelType> DOWEL = MSProperties.DOWEL_OR_NONE;
        private final Map<Direction, VoxelShape> dowelShape;

        public Pad(AlchemiterMultiblock machine, CustomVoxelShape emptyShape, CustomVoxelShape dowelShape, BlockBehaviour.Properties properties) {
            super(machine, emptyShape, false, false, new BlockPos(0, 0, 0), properties);
            this.dowelShape = dowelShape.createRotatedShapes();
        }

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
            if (((EnumDowelType)((Object)state.getValue(DOWEL))).equals((Object)EnumDowelType.NONE)) {
                return super.getShape(state, worldIn, pos, context);
            }
            return this.dowelShape.get(state.getValue((Property)FACING));
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new AlchemiterBlockEntity(pos, state);
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{DOWEL});
        }
    }
}

