/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.MSBlockShapes;
import com.mraof.minestuck.block.machine.AlchemiterBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AlchemiterMultiblock
extends MachineMultiblock {
    public final DeferredBlock<Block> CENTER = this.register("alchemiter_center", () -> new AlchemiterBlock(this, MSBlockShapes.ALCHEMITER_CENTER, true, false, new BlockPos(1, 0, -1), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> CORNER = this.register("alchemiter_corner", () -> new AlchemiterBlock(this, MSBlockShapes.ALCHEMITER_CORNER, true, true, new BlockPos(0, 0, 3), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> LEFT_SIDE = this.register("alchemiter_left_side", () -> new AlchemiterBlock(this, MSBlockShapes.ALCHEMITER_LEFT_SIDE, true, false, new BlockPos(1, 0, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> RIGHT_SIDE = this.register("alchemiter_right_side", () -> new AlchemiterBlock(this, MSBlockShapes.ALCHEMITER_RIGHT_SIDE, true, false, new BlockPos(2, 0, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> TOTEM_CORNER = this.register("alchemiter_totem_corner", () -> new AlchemiterBlock(this, MSBlockShapes.ALCHEMITER_TOTEM_CORNER, false, true, new BlockPos(0, 1, 0), BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    public final DeferredBlock<Block> TOTEM_PAD = this.register("alchemiter_totem_pad", () -> new AlchemiterBlock.Pad(this, MSBlockShapes.ALCHEMITER_TOTEM_PAD, MSBlockShapes.ALCHEMITER_TOTEM_PAD_DOWEL, BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 4.5f).noLootTable()));
    private final MachineMultiblock.PlacementEntry totemPadPos;

    public AlchemiterMultiblock(DeferredRegister.Blocks register) {
        super(register);
        this.addDirectionPlacement(0, 0, 0, (Supplier<Block>)this.CORNER, Direction.WEST);
        this.addDirectionPlacement(0, 0, 1, (Supplier<Block>)this.LEFT_SIDE, Direction.WEST);
        this.addDirectionPlacement(0, 0, 2, (Supplier<Block>)this.RIGHT_SIDE, Direction.WEST);
        this.addDirectionPlacement(1, 0, 1, (Supplier<Block>)this.CENTER, Direction.WEST);
        this.addDirectionPlacement(3, 0, 0, (Supplier<Block>)this.CORNER, Direction.NORTH);
        this.addDirectionPlacement(2, 0, 0, (Supplier<Block>)this.LEFT_SIDE, Direction.NORTH);
        this.addDirectionPlacement(1, 0, 0, (Supplier<Block>)this.RIGHT_SIDE, Direction.NORTH);
        this.addDirectionPlacement(2, 0, 1, (Supplier<Block>)this.CENTER, Direction.NORTH);
        this.addDirectionPlacement(0, 0, 3, (Supplier<Block>)this.CORNER, Direction.SOUTH);
        this.addDirectionPlacement(2, 0, 3, (Supplier<Block>)this.RIGHT_SIDE, Direction.SOUTH);
        this.addDirectionPlacement(1, 0, 3, (Supplier<Block>)this.LEFT_SIDE, Direction.SOUTH);
        this.addDirectionPlacement(1, 0, 2, (Supplier<Block>)this.CENTER, Direction.SOUTH);
        this.addDirectionPlacement(3, 0, 3, (Supplier<Block>)this.TOTEM_CORNER, Direction.EAST);
        this.addDirectionPlacement(3, 0, 2, (Supplier<Block>)this.LEFT_SIDE, Direction.EAST);
        this.addDirectionPlacement(3, 0, 1, (Supplier<Block>)this.RIGHT_SIDE, Direction.EAST);
        this.addDirectionPlacement(2, 0, 2, (Supplier<Block>)this.CENTER, Direction.EAST);
        this.totemPadPos = this.addDirectionPlacement(3, 1, 3, (Supplier<Block>)this.TOTEM_PAD, Direction.EAST);
    }

    public boolean isInvalidFromPad(LevelAccessor level, BlockPos pos) {
        return this.isInvalidFromPlacement((BlockGetter)level, pos, this.totemPadPos);
    }

    public Optional<MachineMultiblock.Placement> findPlacementFromPad(LevelAccessor level, BlockPos pos) {
        return this.totemPadPos.findPlacement(pos, level.getBlockState(pos));
    }
}

