/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.MSBlockShapes;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.computer.theme.MSComputerThemes;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ComputerBlock
extends MachineBlock
implements EntityBlock {
    public static final Map<Direction, VoxelShape> COMPUTER_SHAPE = MSBlockShapes.COMPUTER.createRotatedShapes();
    public static final Map<Direction, VoxelShape> LAPTOP_CLOSED_SHAPE = MSBlockShapes.LAPTOP_CLOSED.createRotatedShapes();
    public static final Map<Direction, VoxelShape> LAPTOP_OPEN_SHAPE = MSBlockShapes.LAPTOP_OPEN.createRotatedShapes();
    public static final Map<Direction, VoxelShape> LUNCHTOP_CLOSED_SHAPE = new CustomVoxelShape(new double[][]{{4.0, 0.0, 1.5, 12.0, 5.0, 8.5}}).createRotatedShapes();
    public static final Map<Direction, VoxelShape> LUNCHTOP_OPEN_SHAPE = MSBlockShapes.LUNCHTOP_OPEN.createRotatedShapes();
    public static final Map<Direction, VoxelShape> OLD_COMPUTER_SHAPE = MSBlockShapes.OLD_COMPUTER.createRotatedShapes();
    public static final EnumProperty<State> STATE = MSProperties.COMPUTER_STATE;
    public final Map<Direction, VoxelShape> shapeOn;
    public final Map<Direction, VoxelShape> shapeOff;
    public final ResourceLocation defaultTheme;

    public ComputerBlock(Map<Direction, VoxelShape> shapeOn, Map<Direction, VoxelShape> shapeOff, BlockBehaviour.Properties properties) {
        this(shapeOn, shapeOff, MSComputerThemes.DEFAULT, properties);
    }

    public ComputerBlock(Map<Direction, VoxelShape> shapeOn, Map<Direction, VoxelShape> shapeOff, ResourceLocation defaultTheme, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)State.OFF)));
        this.shapeOn = shapeOn;
        this.shapeOff = shapeOff;
        this.defaultTheme = defaultTheme;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STATE});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isShiftKeyDown()) {
            BlockState newState = (BlockState)state.setValue(STATE, (Comparable)((Object)State.OFF));
            level.setBlock(pos, newState, 2);
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue(STATE) == State.OFF) {
            this.turnOn(state, level, pos, player);
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ComputerBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        ComputerBlockEntity blockEntity2 = (ComputerBlockEntity)blockEntity;
        ItemStack heldItem = player.getItemInHand(hand);
        if (blockEntity2.tryInsertDisk(player, heldItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (level.isClientSide && SkaiaClient.requestData(blockEntity2)) {
            MSScreenFactories.displayComputerScreen(blockEntity2);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void turnOn(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return;
        }
        level.playSound(null, pos, MSSoundEvents.COMPUTER_BOOT.get(), SoundSource.BLOCKS);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            State computerState = State.ON;
            boolean hasSBURBProgram = computer.installedPrograms().anyMatch(programType -> programType == ProgramTypes.SBURB_CLIENT.get() || programType == ProgramTypes.SBURB_CLIENT.get());
            boolean isBSOD = computer.getDisks().stream().anyMatch(disk -> disk.is(Items.MUSIC_DISC_11));
            if (hasSBURBProgram) {
                computerState = State.GAME_LOADED;
            }
            if (isBSOD) {
                computerState = State.BROKEN;
            }
            BlockState newState = (BlockState)state.setValue(STATE, (Comparable)((Object)computerState));
            level.setBlock(pos, newState, 2);
            if (computer.getOwner() == null) {
                computer.initializeOwner(Objects.requireNonNull(IdentifierHandler.encode(player)));
                computer.setTheme(this.defaultTheme);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ComputerBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.is(state.getBlock())) {
            this.dropItems(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void dropItems(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
            computer.closeAll();
            computer.dropAllDisks();
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue(STATE) == State.OFF) {
            return this.shapeOff.get(state.getValue((Property)FACING));
        }
        return this.shapeOn.get(state.getValue((Property)FACING));
    }

    public static enum State implements StringRepresentable
    {
        OFF,
        ON,
        GAME_LOADED,
        BROKEN;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

