/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.machine.CruxtruderMultiblock;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.blockentity.machine.CruxtruderBlockEntity;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CruxtruderBlock
extends MachineBlock
implements EntityBlock,
EditmodeDestroyable {
    protected final Map<Direction, VoxelShape> shape;
    protected final boolean hasBlockEntity;
    protected final BlockPos mainPos;
    protected final CruxtruderMultiblock multiblock;

    public CruxtruderBlock(CruxtruderMultiblock multiblock, CustomVoxelShape shape, boolean blockEntity, BlockPos mainPos, BlockBehaviour.Properties properties) {
        super(properties);
        this.multiblock = multiblock;
        this.shape = shape.createRotatedShapes();
        this.hasBlockEntity = blockEntity;
        this.mainPos = mainPos;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.hasBlockEntity && (state.getValue((Property)FACING) == hit.getDirection() || hit.getDirection() == Direction.UP)) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CruxtruderBlockEntity) {
                CruxtruderBlockEntity cruxtruder = (CruxtruderBlockEntity)blockEntity;
                cruxtruder.onRightClick(player, hit.getDirection() == Direction.UP);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this.hasBlockEntity) {
            return new CruxtruderBlockEntity(pos, state);
        }
        return null;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos mainPos = this.getMainPos(state, pos);
        BlockEntity blockEntity = level.getBlockEntity(mainPos);
        if (blockEntity instanceof CruxtruderBlockEntity) {
            CruxtruderBlockEntity cruxtruder = (CruxtruderBlockEntity)blockEntity;
            cruxtruder.setBroken();
            if (pos.equals((Object)mainPos)) {
                cruxtruder.dropItems();
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void destroyFull(BlockState state, Level level, BlockPos pos) {
        Optional<MachineMultiblock.Placement> placement = this.multiblock.findPlacementFromTube((LevelAccessor)level, this.getMainPos(state, pos));
        if (placement.isPresent()) {
            this.multiblock.removeAt((LevelAccessor)level, placement.get());
        } else {
            for (MachineMultiblock.Placement placementGuess : this.multiblock.guessPlacement(pos, state)) {
                this.multiblock.removeAt((LevelAccessor)level, placementGuess);
            }
        }
    }

    public BlockPos getMainPos(BlockState state, BlockPos pos) {
        Rotation rotation = MSRotationUtil.fromDirection((Direction)state.getValue((Property)FACING));
        return pos.offset((Vec3i)this.mainPos.rotate(rotation));
    }
}

