/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.machine.GristCollectorBlockEntity;
import com.mraof.minestuck.player.GristCache;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
public class GristCollectorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public GristCollectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<GristCollectorBlock> codec() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            GristCollectorBlockEntity collector;
            GristSet storedGrist;
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(player instanceof FakePlayer) && (blockEntity = level.getBlockEntity(pos)) instanceof GristCollectorBlockEntity && !(storedGrist = (collector = (GristCollectorBlockEntity)blockEntity).getStoredGrist()).isEmpty()) {
                GristCache.get(serverPlayer).addWithGutter(storedGrist, GristHelper.EnumSource.CLIENT);
                collector.clearStoredGrist();
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.1f, 0.5f * ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.8f));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GristCollectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> placedType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, MSBlockEntityTypes.GRIST_COLLECTOR.get(), GristCollectorBlockEntity::serverTick) : null;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        this.updatePower(level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.updatePower(level, pos);
    }

    public void updatePower(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            BlockState state = level.getBlockState(pos);
            boolean hasPower = level.hasNeighborSignal(pos);
            if ((Boolean)state.getValue((Property)POWERED) != hasPower) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)));
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> DustParticleOptions.REDSTONE);
        } else {
            BlockUtil.spawnParticlesAroundSolidBlock(level, pos, () -> new DustParticleOptions(new Vector3f(0.0f, 20.0f, 0.0f), 2.0f));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
    }
}

