/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.machine.MachineBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public abstract class MachineMultiblock
implements ItemLike {
    public static final BiPredicate<BlockState, BlockState> BASE_PREDICATE = (state1, state2) -> state1.getBlock() == state2.getBlock();
    public static final BiPredicate<BlockState, BlockState> ROTATION_PREDICATE = BASE_PREDICATE.and((state1, state2) -> state1.getValue((Property)MachineBlock.FACING) == state2.getValue((Property)MachineBlock.FACING));
    private final DeferredRegister.Blocks register;
    private final List<Supplier<? extends Block>> registryEntries = new ArrayList<Supplier<? extends Block>>();
    private final List<PlacementEntry> blockEntries = new ArrayList<PlacementEntry>();

    protected MachineMultiblock(DeferredRegister.Blocks register) {
        this.register = register;
    }

    protected <B extends Block> DeferredBlock<B> register(String name, Supplier<B> constructor) {
        DeferredBlock registryObject = this.register.register(name, constructor);
        this.registryEntries.add((Supplier<? extends Block>)registryObject);
        return registryObject;
    }

    protected PlacementEntry addPlacement(int x, int y, int z, Supplier<BlockState> stateSupplier, boolean mustExist) {
        return this.addPlacement(new BlockPos(x, y, z), stateSupplier, mustExist, false, true, BASE_PREDICATE);
    }

    protected PlacementEntry addDirectionPlacement(int x, int y, int z, Supplier<Block> regBlock, Direction direction) {
        return this.addPlacement(new BlockPos(x, y, z), MachineMultiblock.applyDirection(regBlock, direction), true, true, true, ROTATION_PREDICATE);
    }

    protected PlacementEntry addDirectionOptional(int x, int y, int z, Supplier<Block> regBlock, Direction direction) {
        return this.addPlacement(new BlockPos(x, y, z), MachineMultiblock.applyDirection(regBlock, direction), false, true, false, ROTATION_PREDICATE);
    }

    protected PlacementEntry addPlacement(BlockPos pos, Supplier<BlockState> stateSupplier, boolean mustExist, boolean isDirectional, boolean isPlaced, BiPredicate<BlockState, BlockState> stateValidator) {
        for (PlacementEntry entry : this.blockEntries) {
            if (!entry.pos.equals((Object)pos)) continue;
            throw new IllegalArgumentException("Can't add placement for the same position " + String.valueOf(pos) + " twice.");
        }
        PlacementEntry entry = new PlacementEntry(stateSupplier, stateValidator, mustExist, isDirectional, isPlaced, pos);
        this.blockEntries.add(entry);
        return entry;
    }

    public Block getMainBlock() {
        return !this.registryEntries.isEmpty() ? this.registryEntries.get(0).get() : null;
    }

    public void forEachBlock(Consumer<Block> consumer) {
        this.registryEntries.forEach(block -> consumer.accept((Block)block.get()));
    }

    public void placeWithRotation(LevelAccessor level, Placement placement) {
        this.blockEntries.forEach(entry -> entry.placeWithRotation(level, placement));
    }

    public void placeAdditional(Level level, Placement placement) {
    }

    private boolean isInvalid(BlockGetter level, Placement placement) {
        for (PlacementEntry entry : this.blockEntries) {
            if (!entry.mustExist || entry.matchesWithRotation(level, entry.getPos(placement), placement.rotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInvalidFromPlacement(BlockGetter level, BlockPos pos, PlacementEntry entry) {
        BlockState worldState = level.getBlockState(pos);
        return this.isInvalid(level, entry.findPlacementOrThrow(pos, worldState));
    }

    public List<Placement> guessPlacement(BlockPos pos, BlockState state) {
        ArrayList<Placement> placements = new ArrayList<Placement>();
        for (PlacementEntry entry : this.blockEntries) {
            entry.findPlacement(pos, state).ifPresent(placements::add);
        }
        return placements;
    }

    public void removeAt(LevelAccessor level, Placement placement) {
        for (PlacementEntry entry : this.blockEntries) {
            entry.removeIfMatching(level, placement);
        }
    }

    public BoundingBox getBoundingBox(Rotation rotation) {
        return (BoundingBox)BoundingBox.encapsulatingPositions(this.blockEntries.stream().map(entry -> entry.pos.rotate(rotation)).toList()).orElseThrow();
    }

    @Nonnull
    public Item asItem() {
        return this.getMainBlock().asItem();
    }

    protected static Supplier<BlockState> applyDirection(Supplier<Block> block, Direction direction) {
        return () -> (BlockState)((Block)block.get()).defaultBlockState().setValue((Property)MachineBlock.FACING, (Comparable)direction);
    }

    protected static class PlacementEntry {
        @Nonnull
        private final Supplier<BlockState> stateSupplier;
        private final BiPredicate<BlockState, BlockState> stateValidator;
        private final boolean mustExist;
        private final boolean isDirectional;
        private final boolean isPlaced;
        private final BlockPos pos;

        private PlacementEntry(Supplier<BlockState> stateSupplier, BiPredicate<BlockState, BlockState> stateValidator, boolean mustExist, boolean isDirectional, boolean isPlaced, BlockPos pos) {
            this.stateSupplier = Objects.requireNonNull(stateSupplier);
            this.stateValidator = Objects.requireNonNull(stateValidator);
            this.mustExist = mustExist;
            this.isDirectional = isDirectional;
            this.isPlaced = isPlaced;
            this.pos = pos;
        }

        private BlockState getRotatedState(Rotation rotation) {
            return Objects.requireNonNull(this.stateSupplier.get()).rotate(rotation);
        }

        private void placeWithRotation(LevelAccessor level, Placement placement) {
            if (this.isPlaced) {
                BlockState state = this.getRotatedState(placement.rotation);
                level.setBlock(this.getPos(placement), state, 3);
            }
        }

        private boolean matchesWithRotation(BlockGetter level, BlockPos pos, Rotation rotation) {
            BlockState machineState = this.getRotatedState(rotation);
            BlockState worldState = level.getBlockState(pos);
            return this.stateValidator.test(machineState, worldState);
        }

        private void removeIfMatching(LevelAccessor level, Placement placement) {
            BlockPos pos = this.getPos(placement);
            if (this.matchesWithRotation((BlockGetter)level, pos, placement.rotation)) {
                level.destroyBlock(pos, false);
            }
        }

        public BlockPos getPos(Placement placement) {
            return placement.zeroPos.offset((Vec3i)this.pos.rotate(placement.rotation));
        }

        public Placement getPlacement(BlockPos pos, Rotation rotation) {
            return new Placement(pos.subtract((Vec3i)this.pos.rotate(rotation)), rotation);
        }

        public Optional<Placement> findPlacement(BlockPos pos, BlockState rotatedState) {
            if (!this.isDirectional) {
                return Optional.empty();
            }
            for (Rotation rotation : Rotation.values()) {
                if (!this.stateValidator.test(this.getRotatedState(rotation), rotatedState)) continue;
                return Optional.of(this.getPlacement(pos, rotation));
            }
            return Optional.empty();
        }

        public Placement findPlacementOrThrow(BlockPos pos, BlockState rotatedState) {
            return this.findPlacement(pos, rotatedState).orElseThrow(() -> new IllegalArgumentException("No valid rotation found to match state " + String.valueOf(rotatedState) + " with " + String.valueOf(this.stateSupplier.get())));
        }
    }

    public record Placement(BlockPos zeroPos, Rotation rotation) {
    }
}

