/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.BlockUtil;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class MachineProcessBlock
extends MachineBlock {
    public MachineProcessBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, state, null, null);
            if (itemHandler != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemHandler.getStackInSlot(i));
                }
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createMachineTicker(Level level, BlockEntityType<T> placedType, BlockEntityType<? extends MachineProcessBlockEntity> blockType) {
        return !level.isClientSide ? BlockUtil.checkTypeForTicker(placedType, blockType, MachineProcessBlockEntity::serverTick) : null;
    }
}

