/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.CustomVoxelShape;
import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.block.machine.MachineMultiblock;
import com.mraof.minestuck.block.machine.PunchDesignixMultiblock;
import com.mraof.minestuck.blockentity.machine.PunchDesignixBlockEntity;
import com.mraof.minestuck.util.MSRotationUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PunchDesignixBlock
extends MachineBlock
implements EditmodeDestroyable {
    protected final Map<Direction, VoxelShape> shape;
    protected final BlockPos mainPos;
    protected final PunchDesignixMultiblock multiblock;

    public PunchDesignixBlock(PunchDesignixMultiblock multiblock, CustomVoxelShape shape, BlockPos pos, BlockBehaviour.Properties properties) {
        super(properties);
        this.multiblock = multiblock;
        this.shape = shape.createRotatedShapes();
        this.mainPos = pos;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos mainPos = this.getMainPos(state, pos);
        BlockEntity blockEntity = level.getBlockEntity(mainPos);
        if (blockEntity instanceof PunchDesignixBlockEntity) {
            PunchDesignixBlockEntity designix = (PunchDesignixBlockEntity)blockEntity;
            designix.onRightClick(player, state);
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockPos mainPos = this.getMainPos(state, pos);
            BlockEntity blockEntity = level.getBlockEntity(mainPos);
            if (blockEntity instanceof PunchDesignixBlockEntity) {
                PunchDesignixBlockEntity designix = (PunchDesignixBlockEntity)blockEntity;
                designix.breakMachine();
                if (pos.equals((Object)mainPos)) {
                    designix.dropItem(true);
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public void destroyFull(BlockState state, Level level, BlockPos pos) {
        Optional<MachineMultiblock.Placement> placement = this.multiblock.findPlacementFromSlot((LevelAccessor)level, this.getMainPos(state, pos));
        if (placement.isPresent()) {
            this.multiblock.removeAt((LevelAccessor)level, placement.get());
        } else {
            for (MachineMultiblock.Placement placementGuess : this.multiblock.guessPlacement(pos, state)) {
                this.multiblock.removeAt((LevelAccessor)level, placementGuess);
            }
        }
    }

    public BlockPos getMainPos(BlockState state, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Rotation rotation = MSRotationUtil.fromDirection(direction);
        return pos.offset((Vec3i)this.mainPos.rotate(rotation));
    }

    public static class Slot
    extends PunchDesignixBlock
    implements EntityBlock {
        public static final BooleanProperty HAS_CARD = MSProperties.HAS_CARD;

        public Slot(PunchDesignixMultiblock machine, CustomVoxelShape shape, BlockBehaviour.Properties properties) {
            super(machine, shape, new BlockPos(0, 0, 0), properties);
            this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_CARD, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            builder.add(new Property[]{HAS_CARD});
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new PunchDesignixBlockEntity(pos, state);
        }
    }
}

