/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.block.machine;

import com.mraof.minestuck.block.machine.MachineProcessBlock;
import com.mraof.minestuck.blockentity.machine.IOwnable;
import com.mraof.minestuck.blockentity.machine.MachineProcessBlockEntity;
import com.mraof.minestuck.player.IdentifierHandler;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class SmallMachineBlock<T extends MachineProcessBlockEntity>
extends MachineProcessBlock
implements EntityBlock {
    private final Map<Direction, VoxelShape> shape;
    private final Supplier<BlockEntityType<T>> entityType;

    public SmallMachineBlock(Map<Direction, VoxelShape> shape, Supplier<BlockEntityType<T>> entityType, BlockBehaviour.Properties properties) {
        super(properties);
        this.shape = shape;
        this.entityType = entityType;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape.get(state.getValue((Property)FACING));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null && blockEntity.getType() == this.entityType.get()) {
                if (blockEntity instanceof IOwnable) {
                    IOwnable ownable = (IOwnable)blockEntity;
                    ownable.setOwner(IdentifierHandler.encode(player));
                }
                if (blockEntity instanceof MenuProvider) {
                    MenuProvider menuProvider = (MenuProvider)blockEntity;
                    serverPlayer.openMenu(menuProvider, pos);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.entityType.get().create(pos, state);
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityTicker<E> getTicker(Level level, BlockState state, BlockEntityType<E> placedType) {
        return SmallMachineBlock.createMachineTicker(level, placedType, this.entityType.get());
    }
}

